/*
 * med2xml.c
 * 
 * Copyright (c) Chris Putnam 2004-5
 *
 * Source code and program released under the GPL
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include "bibutils.h"
#include "bibprogs.h"


int med2xml(char *input, char *output)
{
	char progname[] = "med2xml";
	FILE *fp;
	param p;
	bibl b;
	int err, i;
	bibl_init( &b );
	bibl_initparams( &p, BIBL_MEDLINEIN, BIBL_MODSOUT );
	//tomods_processargs( &argc, argv, &p, progname, help1, help2 );
	fp = fopen(input, "r" );
	if ( fp ) {
		err = bibl_read( &b, fp, input, BIBL_MEDLINEIN, &p );
		if ( err ) bibl_reporterr( err );
		fclose( fp );
	}
	FILE *out_file;
	out_file = fopen(output, "w" );
	if (!err)
		bibl_write( &b, out_file, BIBL_MODSOUT, &p );
	fclose( out_file );
	fprintf( stderr, "%s: Processed %ld references.\n", progname, b.nrefs );
	bibl_free( &b );
	return EXIT_SUCCESS;
}
	
	
