//
// C++ Interface: kbibremotesearchdlg
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KBIBREMOTESEARCHDLG_H
#define KBIBREMOTESEARCHDLG_H

#include "kbibpreview.h"
#include "searchmanager.h"

#include <kdialogbase.h>
#include <kcombobox.h>
#include <klistview.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <kstatusbar.h>
#include <qtextedit.h>
#include <qcheckbox.h>

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
class KBibRemoteSearchDlg : public KDialogBase
{
Q_OBJECT
public:
    KBibRemoteSearchDlg(QWidget *parent = 0, const char *name = 0);
	~KBibRemoteSearchDlg();
	public:
		void stop();
	private slots:
		void slotSourceSelected(const QString&);
		void slotSearchClick();
		void slotAddEntryClick();	
		void slotClearClick();
		void slotEntryClick(QListViewItem *);
		void slotSelectionChanged();
		void slotResultFound(BibEntry*);
		void slotQueryResult(unsigned int);
		void slotMessage(QString, int );
		void slotSearchDone();
	
private:
	KComboBox* dataSource;
	KComboBox* searchKey1, *searchKey2, *searchKey3;
	KComboBox* operator1, *operator2;
	KLineEdit* searchTerms1, *searchTerms2, *searchTerms3;
	KPushButton* searchButton;
	KListView* listView;
	QTextEdit* entryPreview;
	QCheckBox* ignoreExistingSelect;
	QCheckBox* createKeySelect;
	KPushButton* addButton;
	KPushButton* clearButton;
	
//	searchManager *m_manager;
	
	bool m_started;
};

#endif
