//
// C++ Implementation: kbibstringmacrodlg
//
// Description:
//
//
// Author: Thach Nguyen <thach@dragon.thach.com>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kbibstringmacrodlg.h"

#include <klocale.h>
#include <klineedit.h>
#include <kbuttonbox.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <klistview.h>

#include <qlayout.h>
#include <qlistview.h>
#include <qheader.h>
#include <qhbox.h>
#include <qpushbutton.h>
#include <qwhatsthis.h>

KbibStringMacroDlg::KbibStringMacroDlg(BibentryTable* entryList, QMap<QString, QString> globalMap_, QWidget* parent_, const char* name_/*=0*/, bool modal_/*=false*/)
        : KDialogBase(parent_, name_, modal_, QString::null, Ok|Cancel)
{
    globalMap = globalMap_;

    QWidget* page = new QWidget(this);
    QVBoxLayout* l = new QVBoxLayout(page, 0, KDialog::spacingHint());

    m_listView = new KListView(page);
    m_listView->setAllColumnsShowFocus(true);
    m_listView->setShowSortIndicator(true);
    m_listView->addColumn(i18n("Key" ));
    m_listView->addColumn(i18n("Text" ));
    m_listView->setColumnWidthMode(0, QListView::Maximum);
    m_listView->setColumnWidthMode(1, QListView::Maximum);
    m_listView->setResizeMode(QListView::AllColumns);
    connect(m_listView, SIGNAL(clicked(QListViewItem*)), SLOT(slotClicked(QListViewItem*)));
    l->addWidget(m_listView);

    QHBox* box = new QHBox(page);
    box->setMargin(4);
    box->setSpacing(4);

    m_editID = new KLineEdit(box);
    m_editValue = new KLineEdit(box);
    KButtonBox* bb = new KButtonBox(box);
    bb->addStretch(1);
    QPushButton* btn = bb->addButton(i18n("&Add"), this, SLOT(slotAdd()));
    btn->setIconSet(BarIcon(QString::fromLatin1("add"), KIcon::SizeSmall));
    btn = bb->addButton(i18n("&Delete"), this, SLOT(slotDelete()));
    btn->setIconSet(BarIcon(QString::fromLatin1("editdelete"), KIcon::SizeSmall));
    bb->addButton(i18n("From &Global List"), this, SLOT(slotGlobal()));
    l->addWidget(box);
    //l->setStretchFactor(m_editID, 1);
    //l->setStretchFactor(m_editValue, 1);
    //l->setStretchFactor(bb, 0);
    //l->addStretch(0);
    setMainWidget(page);

    setMinimumWidth(400);
    enableButtonSeparator(true);

    //Set content
	QMap<QString, QString> macros = entryList->getStringMacros();
    QMap<QString, QString>::Iterator it;
    for ( it = macros.begin(); it != macros.end(); ++it ) {
        (void) new KListViewItem(m_listView, it.key(), it.data() );

    }


}



KbibStringMacroDlg::~KbibStringMacroDlg()
{
    delete m_listView;
    delete m_editID;
    delete m_editValue;
}


void KbibStringMacroDlg::slotAdd()
{
    QString s1 = m_editID->text();
    QString s2 = m_editValue->text();
    addNewString(s1, s2);
    m_editID->clear();
    m_editValue->clear();
}

void KbibStringMacroDlg::slotDelete()
{
    delete m_listView->currentItem();
    m_editID->clear();
    m_editValue->clear();
    m_listView->setSelected(m_listView->currentItem(), true);
}

void KbibStringMacroDlg::slotGlobal()
{
    m_listView->clearSelection();
    GlobalStringMacroDlg *globalMacroDlg = new GlobalStringMacroDlg(globalMap, this, "String Macro");
    globalMacroDlg->setCaption(i18n("Global String Macros") );
    if (globalMacroDlg->exec() == QDialog::Accepted)
    {
        QMap<QString, QString> map = globalMacroDlg->getMacros();
        for(QMap<QString, QString>::ConstIterator it = map.begin(); it != map.end(); ++it)
        {
            addNewString(it.key(), it.data() );
        }
    }
	delete globalMacroDlg;
}

void KbibStringMacroDlg::slotClicked(QListViewItem* item_)
{
    if(item_)
    {
        m_editID->setText(item_->text(0));
        m_editValue->setText(item_->text(1));
        m_listView->header()->adjustHeaderSize();
    }
}

void KbibStringMacroDlg::addNewString(QString ID, QString text)
{
    if(ID.isEmpty() && text.isEmpty())
    {
        return;
    }
    QListViewItem* item = m_listView->selectedItem();
    if(item && ID == item->text(0))
    {
        item->setText(1, text);
    }
    else
    {
        bool existing = false;
        for(item = m_listView->firstChild(); item; item = item->nextSibling())
        {
            if (ID == item->text(0) && text != item->text(1))
            {
                existing = true;
                break;
            }
            if (ID == item->text(0) && text == item->text(1))
            {
                return;
            }
        }
        if (existing)
        {
            if (KMessageBox::warningYesNo(this, i18n("A string macro with Key = \"%1\" and Text = \"%2\" already exists. Do you want to replace it?").arg(ID).arg(item->text(1)),i18n("Warning")) == KMessageBox::Yes)
            {
                item->setText(1, text);
            }
        }
        else
            item = new KListViewItem(m_listView, ID, text);


    }
    m_listView->ensureItemVisible(item);
    m_listView->setSelected(item, true);
}

QMap<QString, QString> KbibStringMacroDlg::getStringMacroList(){
	QMap<QString, QString> map;
    for(QListViewItem* item = m_listView->firstChild(); item; item = item->nextSibling())
	{
		map.insert(item->text(0), item->text(1));
	}
    return map;
}


GlobalStringMacroDlg::GlobalStringMacroDlg(QMap<QString, QString>& map_, QWidget* parent_, const char* name_, bool modal_)
        : KDialogBase(parent_, name_, modal_, QString::null, Ok|Cancel)
{
    QWidget* page = new QWidget(this);
    QVBoxLayout* l = new QVBoxLayout(page, 0, KDialog::spacingHint());

    m_listView = new KListView(page);
    m_listView->setAllColumnsShowFocus(true);
    m_listView->setShowSortIndicator(true);
    m_listView->setSelectionMode(QListView::Extended);
    m_listView->addColumn(i18n("ID" ));
    m_listView->addColumn(i18n("Text" ));
    m_listView->setColumnWidthMode(0, QListView::Maximum);
    m_listView->setColumnWidthMode(1, QListView::Maximum);
    m_listView->setResizeMode(QListView::AllColumns);
    l->addWidget(m_listView);
    for(QMap<QString, QString>::ConstIterator it = map_.begin(); it != map_.end(); ++it)
    {
        if(!it.data().isEmpty())
        {
            (void) new KListViewItem(m_listView, it.key(), it.data());
        }
    }

    setMainWidget(page);

    setMinimumWidth(400);
    enableButtonSeparator(true);

}

GlobalStringMacroDlg::~GlobalStringMacroDlg()
{}

QMap<QString, QString> GlobalStringMacroDlg::getMacros()
{
    QMap<QString, QString> map;
    for(QListViewItem* item = m_listView->firstChild(); item; item = item->nextSibling())
    {
        if (item->isSelected())
            map.insert(item->text(0), item->text(1));
    }
    return map;
}




#include "kbibstringmacrodlg.moc"
