/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sat May 24 16:37:30 EST 2003
    copyright            : (C) 2003 by Thach Nguyen
    email                : thach@dragon.thach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kstartupinfo.h>
#include <klocale.h>
#include <dcopclient.h>
#include <qfileinfo.h>
#include "kbib.h"

static const char *description =
    I18N_NOOP ( "KBib - A BibTex management program for KDE\nBibTex file processing code is based on gbib v0.1.2\nImporting/exporting filters are based on bibutils v3.27" );



static KCmdLineOptions options[] =
    {
        { "+[File]", I18N_NOOP ( "file to open" ), 0 },
        { "i <file> ", I18N_NOOP ( "Insert file" ), 0 },
        { "t <type> ", I18N_NOOP ( "File type" ), "bib" },
        { 0, 0, 0 }
        // INSERT YOUR COMMANDLINE OPTIONS HERE
    };

int main ( int argc, char *argv[] )
{
	KAboutData aboutData ( "kbib", I18N_NOOP ( "KBib" ),
	                       VERSION, description, KAboutData::License_GPL,
	                       "(c) 2003-2006, Thach Nguyen", 0, "http://user.digisurf.com.au/~thachly/kbib", "thach.nguyen@rmit.edu.au" );
	aboutData.addAuthor ( "Thach Nguyen",0, "thach.nguyen@rmit.edu.au" );
	KCmdLineArgs::init ( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions ( options ); // Add our own options.
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
	bool running = false;




	DCOPClient *client=0L;
	QCString appID = "";
	client  = new DCOPClient ();
	client->attach();


	QCStringList apps = client->registeredApplications();

	for ( QCStringList::Iterator it = apps.begin(); it != apps.end(); ++it )
	{
		if ( (*it) == "kbib" || (*it).contains ( "kbib-" ) > 0 )
		{
			appID = ( *it );
			running = true;
			break;
		}
	}

	QString insertFile = args->getOption ( "i" );
	int fileType = 0;
	if ( insertFile )
	{
		QString fileTypeStr = args->getOption ( "t" );

		cerr << "\nFile to insert " << insertFile.ascii() << " Type " << fileTypeStr.ascii();
		if ( fileTypeStr )
		{

			if ( fileTypeStr.compare ( "bib" ) == 0 )
			{
				fileType = 0;
			}
			else if ( fileTypeStr.compare ( "end" ) == 0 )
			{
				fileType = 2;
			}
			else if ( fileTypeStr.compare ( "ris" ) == 0 )
			{
				fileType = 3;
			}
			else if ( fileTypeStr.compare ( "isi" ) == 0 )
			{
				fileType = 4;
			}
		}
	}


	if ( insertFile && running )
	{
		QByteArray data;
  	 	QDataStream arg(data, IO_WriteOnly);
  		arg << insertFile.stripWhiteSpace() << fileType << 0;
		client->send( appID, "kbibapp", "insertFile(QString, int, bool)", data);
		KStartupInfo::appStarted();

		client->send ("kbib", "kbibapp", "setActive()", data);
		
		return 0;

	}
	else
	{
		KApplication app;
		app.dcopClient()->registerAs ( "kbib", false );

		if ( app.isRestored() )
		{
			cerr << "Restore Kbib\n";
			RESTORE ( KBibApp );
		}
		else
		{
			KBibApp *kbib = new KBibApp();
			app.setMainWidget(kbib);
			kbib->show();

			if ( args->count() )
			{
				int fileType = 0;
				KURL url = args->url ( 0 );
				QFileInfo fi ( url.fileName() );
				QString ext = ( fi.extension ( FALSE ) ).lower();
				cerr << "\nExtension = " << ext << "A\n";
				if ( ext == QString ( "end" ) )
					fileType = 2;
				else if ( ext == QString ( "ris" ) || ext == QString ( "enl" ) )
					fileType = 3;
				else if ( ext == QString ( "isi" ) )
					fileType = 4;

				if ( fileType == 0 )
				{
					kbib->openDocument ( url );
				}

				else
				{
					kbib->startup();
					kbib->insertFile ( url.url(), fileType, FALSE );
				}


			}
			else
			{
				kbib->startup();

			}

			if ( insertFile )
			{
				kbib->insertFile ( insertFile.stripWhiteSpace(), fileType, FALSE );

			}

			args->clear();

		}

		return app.exec();
	}
}
