//
// C++ Interface: newentryfromtextdialog
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef NEWENTRYFROMTEXTDIALOG_H
#define NEWENTRYFROMTEXTDIALOG_H

#include <kdialogbase.h>

class KPushButton;
class KComboBox;
class KTextEdit;
class KPopupMenu;

class BibEntry;
/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
class NewEntryFromTextDialog : public KDialogBase
{
Q_OBJECT
public:
    NewEntryFromTextDialog(QWidget *parent = 0, const char *name = 0, QString text=QString::null);

    ~NewEntryFromTextDialog();
	BibEntry *getBibEntry() const { return m_entry; }
	private slots:
		void slotClearClicked();
		void slotPasteClicked();
		void slotPDFClicked();
		void slotOpenClicked();	
		void slotEntryTypeChange(int);
		void slotSelectionChanged();
		void slotFieldMenuActivated(int);
	
private:
	BibEntry* m_entry;
	KPushButton *m_clear;
	KPushButton *m_paste;
	KPushButton *m_open;
	KPushButton *m_pdf;
//	KPushButton *m_assign;
	KComboBox *m_entryType;
	KTextEdit *m_edit;	
	KTextEdit *entryPreview;
	KPopupMenu* m_fieldMenu;
	
};

#endif
