/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef SEARCHER_H
#define SEARCHER_H

#include "bibentry.h"
#include "searcherconfigwidget.h"
#include <kapplication.h> // for KApplication::random()

#include <qobject.h>
#include <qstring.h>

#define Z3950_DEFAULT_PORT 210


enum Type {
  Unknown = -1,
  Z3950=0,
  SRU,
  Entrez,
  IEEEXplore,
  WOK
};

enum SearchKey {
	All,
	Title,
	Author,
	Keyword,
	Subject,
	Journal,
	Year,
 	Topic
};

class QStringList;

class searcher : public QObject {
Q_OBJECT

public:
	searcher(QObject* parent, const char* name = 0) : QObject(parent, name) {}
  /**
   */
	virtual ~searcher() {}

  /**
   * Returns the type of the data source.
   */
  virtual Type type() const = 0;
  /**
   * Returns the name of the data source, as defined by the user.
   */
  virtual QString source() const = 0;
  virtual void setSource(const QString ) = 0;
 
  virtual void readConfig(KConfig* config, const QString& group) = 0;
  virtual void saveConfig(KConfig* config) = 0;
  virtual void search(SearchKey key1, SearchKey key2, SearchKey key3 , const QString& value1, const QString& value2, const QString& value3, int operator1, int operator2) = 0;
  virtual bool isSearching() const = 0;
  virtual bool isWaitingRetrieveRange() const = 0;
  virtual void stop() = 0;
  virtual void retrieveRange(unsigned int min, unsigned int max) = 0;
  virtual SearcherConfigWidget* configWidget(QWidget* parent) = 0;
  virtual QStringList searchKey() = 0;
  virtual int maxSearchTerms() = 0;

signals:
	void signalResultFound(BibEntry* e);
	void signalQueryResult(unsigned int);
	void signalMessage(QString, int);
	void signalDone(searcher *);
protected:
		QString m_name;
		bool m_waitingRetrieveRange;
 
};

#endif
