//
// C++ Implementation: urlfieldwidget
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "urlfieldwidget.h"
#include <qlayout.h>
#include <kurlrequester.h>
#include <qcheckbox.h>
#include <kpushbutton.h>
#include <kdialog.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kurlcompletion.h>
#include <klineedit.h>
#include <qwhatsthis.h>
#include <qtooltip.h>

namespace GUI {

UrlFieldWidget::UrlFieldWidget(QString _name, RefField* field,  QStringList macroKeys, QWidget *parent, const char *name)
 : FieldWidget(parent, name)
{
	m_field = field;
	m_name = _name;
	QHBoxLayout* l = new QHBoxLayout(this, 0, KDialog::spacingHint()); 
	QString fn = m_name.lower();
	QChar c = fn.at(0); 
	fn = fn.replace(0, 1, c.upper());
	
	m_label = new QLabel(fn+QString::fromLatin1(":"), this);
	m_requester = new KURLRequester(this);
	QString msg = i18n("Enter the value of the %1 field here.").arg(m_name.lower());
	QWhatsThis::add ( m_requester, msg );
	QToolTip::add ( m_requester, msg );
	m_label->setBuddy(m_requester);
	
	m_requester->lineEdit()->setCompletionObject(new KURLCompletion());
  	m_requester->lineEdit()->setAutoDeleteCompletionObject(true);
	
	m_stringMacroIndicator = new QCheckBox(i18n("As String Macro"), this);
	msg = i18n("When checked, the value of the %1 field is a string macro key.").arg(m_name.lower());
	QWhatsThis::add ( m_stringMacroIndicator, msg );
	QToolTip::add ( m_stringMacroIndicator, msg );
	
	m_stringMacroSelect = new KPushButton(i18n("Macros"), this);
	msg = i18n("Set the %1 field to use one of the defined string macro keys.").arg(m_name.lower());	
	QWhatsThis::add ( m_stringMacroSelect, msg );
	QToolTip::add ( m_stringMacroSelect, msg );
	l->addWidget(m_label);
	l->addWidget(m_requester);
	l->addWidget(m_stringMacroIndicator);
	l->addWidget(m_stringMacroSelect);
	
	m_stringMacroMenu = new KPopupMenu(this);
	m_stringMacroSelect->setPopup(m_stringMacroMenu);
	
	for ( QStringList::Iterator it = macroKeys.begin(); it != macroKeys.end(); ++it ) {
        m_stringMacroMenu->insertItem(*it);
    }
	
	if (m_stringMacroMenu->count () > 0)
		 m_stringMacroSelect->show();
	else
		m_stringMacroSelect->hide();
	
	connect(m_stringMacroMenu, SIGNAL(activated(int)),
			this, SLOT(slotMacroMenuActivated(int)));
	
}


UrlFieldWidget::~UrlFieldWidget()
{
}

void UrlFieldWidget::setText(QString st)
{
	m_requester->lineEdit()->setText(st);	
	m_requester->lineEdit()->setCursorPosition(0);
	
}


QString UrlFieldWidget::getText(void){
	return m_requester->lineEdit()->text();
}

void UrlFieldWidget::slotMacroMenuActivated(int id){
	m_requester->lineEdit()->setText(m_stringMacroMenu->text(id));
	m_stringMacroIndicator->setChecked(true);	
	m_requester->lineEdit()->setFocus ();
}
	
}
#include "urlfieldwidget.moc"
