/***************************************************************************
 *   Copyright (C) 2004-2005 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qfile.h>
#include <qapplication.h>
#include <qspinbox.h>

#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include <kio/netaccess.h>
#include <kurl.h>

#include <fileimporterbibtex.h>
#include "webquerygooglescholar.h"

namespace KBibTeX
{
    WebQueryGoogleScholar::WebQueryGoogleScholar( QWidget* parent, const char* name ): WebQuery( parent, name )
    {
        m_wizard = new WebQueryWizardGoogleScholar( title(), parent, name );
    }

    WebQueryGoogleScholar::~WebQueryGoogleScholar()
    {
        delete m_wizard;
    }

    BibTeX::File* WebQueryGoogleScholar::query( )
    {
        if ( m_wizard->exec() == QDialog::Accepted )
            return m_wizard->result();
        else
            return NULL;
    }

    int WebQueryGoogleScholar::uniqueId()
    {
        return 0x01be9bc4;
    }

    QString WebQueryGoogleScholar::title()
    {
        return i18n( "Google Scholar" );
    }

    WebQueryWizardGoogleScholar::WebQueryWizardGoogleScholar( const QString& caption, QWidget* parent, const char* name ): WebQueryWizard( caption, i18n( "Google Scholar" ), "http://scholar.google.com/intl/en/scholar/about.html", FALSE, TRUE, parent, name )
    {
// nothing
    }

    WebQueryWizardGoogleScholar::~WebQueryWizardGoogleScholar()
    {
// nothing
    }

    void WebQueryWizardGoogleScholar::startSearch()
    {
        setEnabled( FALSE );
        QApplication::setOverrideCursor( Qt::waitCursor );
        m_listViewResults->clear();

        KURL url = KURL( QString( "http://scholar.google.de/scholar?q=%1&ie=UTF-8&num=%2" ).arg( m_lineEditQuery->text().replace( "%", "%25" ).replace( " ", "+" ).replace( "?", "%3F" ).replace( "&", "%26" ) ).arg( m_spinBoxMaxHits->text() ) );
        QString tmpFile;
        if ( KIO::NetAccess::download( url, tmpFile, NULL ) )
        {
            QFile inputFile( tmpFile );
            inputFile.open( IO_ReadOnly );
            QTextStream ts( &inputFile );
            QString completeText = ts.read();
            inputFile.close();
            KIO::NetAccess::removeTempFile( tmpFile );

            BibTeX::FileImporterBibTeX importer( FALSE );
            importer.setIgnoreComments( TRUE );
            int pos = completeText.find( "&q=related:" );
            int maxCount = m_spinBoxMaxHits->value();
            while ( pos > -1 && ( maxCount-- ) > 0 )
            {
                QString key = "";
                pos += 11;
                while ( completeText[pos] != ':' )
                    key.append( completeText[pos++] );
                kdDebug() << "key= " << key << endl;

                KURL keyUrl = KURL( QString( "http://scholar.google.de/scholar.bib?q=info:%1:scholar.google.com/&output=citation&oe=ASCII&oi=citation" ).arg( key ) );
                kdDebug() << "WebQueryWizardGoogleScholar::startSearch:  KeyUrl=" << keyUrl.prettyURL() << endl;

                QString keyTmpFile;
                if ( KIO::NetAccess::download( keyUrl, keyTmpFile, NULL ) )
                {
                    QFile tmpInputFile( keyTmpFile );
                    tmpInputFile.open( IO_ReadOnly );
                    BibTeX::File *tmpBibFile = importer.load( &tmpInputFile );
                    tmpInputFile.close();
                    KIO::NetAccess::removeTempFile( keyTmpFile );

                    for ( BibTeX::File::ElementList::iterator it = tmpBibFile->begin(); it != tmpBibFile->end(); ++it )
                    {
                        BibTeX::Entry *entry = dynamic_cast<BibTeX::Entry*>( *it );
                        if ( entry != NULL )
                            new ResultsListViewItem( m_listViewResults, new BibTeX::Entry( entry ) );
                    }

                    delete tmpBibFile;
                }

                pos = completeText.find( "&q=related:", pos + 1 );
            }

        }
        else
            KMessageBox::error( this, KIO::NetAccess::lastErrorString() );

        setEnabled( TRUE );
        QApplication::restoreOverrideCursor();
    }

}
