/***************************************************************************
                          kcoloreditview.h  -  description
                             -------------------
    begin                : Sat Jul  8 09:57:28 CEST 2000
    copyright            : (C) 2000 by Artur Rataj
    email                : art@zeus.polsl.gliwice.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOLOREDITVIEW_H
#define KCOLOREDITVIEW_H

// include files for Qt
#include <qsplitter.h>
#include <qcheckbox.h>
#include <qlabel.h>

// application specific includes
#include "colorselector.h"
#include "paletteview.h"

class KColorEditDoc;

/** The KColorEditView class provides the view widget for the KColorEditApp instance.
 * The View instance inherits QWidget as a base class and represents the view object of a KXmlGuiWindow. As KColorEditView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the KColorEditApp class to manipulate and display
 * the document structure provided by the KColorEditDoc class.
 *
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class KColorEditView : public QSplitter {
  Q_OBJECT

  public:
    /** Constructor for the main view */
    KColorEditView(QWidget *parent = 0, const char *name = 0);
    /** Destructor for the main view */
    ~KColorEditView();

    /** returns a pointer to the document connected to the view instance. Mind that this method requires a KColorEditApp instance as a parent
     * widget to get to the window document pointer by calling the KColorEditApp::getDocument() method.
     *
     * @see KColorEditApp#getDocument
     */
    KColorEditDoc *document() const;

    /** Contains the implementation for printing functionality */
    void print(QPrinter *pPrinter);
		/** Chooses a color to the color selector */
		void chooseColor(Color* const color);
		/** Updates the view after the document has been changed */
		void redraw(bool newDocument);

	public slots:
		/** Notifies that the cursor position changed */
		void slotCursorPosChanged(int position);
		/** Whether to view color names */
		void slotViewColorNames(bool viewColorNames);

	protected:
		ColorSelector* colorSelector;
		PaletteView* paletteView;

	protected slots:
		/** Adds a color from color selector at cursor position. It inserts or replaces a color,
		 *  depending on addColorMode
		 */
		void slotAddColor();
		/** Sets if add a color at cursor */
		void slotAddColorAtCursor(bool atCursor);
		/** Sets whether insert or replace a color */
		void slotAddColorOverwrite(bool overwrite);
		/** Sets a color name */
		void slotSetColorName(const QString& name);

	protected:
		/** Add color mode constants */
		enum { INSERT_COLOR = 0,
		       REPLACE_COLOR = 1 };

		/** Color mode widget */
		QCheckBox* overwriteCheckBox;
		/** Color name widget */
		QLineEdit* colorName;
		/** H component value label of the color at cursor */
		QLabel* colorAtCursorHValueLabel;
		/** S component value label of the color at cursor */
		QLabel* colorAtCursorSValueLabel;
		/** V component value label of the color at cursor */
		QLabel* colorAtCursorVValueLabel;
		/** R component value label of the color at cursor */
		QLabel* colorAtCursorRValueLabel;
		/** G component value label of the color at cursor */
		QLabel* colorAtCursorGValueLabel;
		/** B component value label of the color at cursor */
		QLabel* colorAtCursorBValueLabel;
		/** RGB Hex string value label of the color at cursor */
		QLabel* colorAtCursorRgbStringValueLabel;
		/** If add a color at cursor */
		bool addColorAtCursor;
		/** Add color mode */
		int addColorMode;
		/** If in color name changing */
		bool inColorNameChanging;
		/** Whether not to update color labels */
		bool doNotUpdateColorLabels;

	protected:
		/** Sets component value label of the color at cursor sizes */
		void setColorAtCursorComponentValueLabelSizes(QLabel* const label);
		/** Updates color value labels */
		void updateColorValueLabels();
};

#endif // KCOLOREDITVIEW_H
