/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004, 2005  by Michael Buesch                           *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "ipc.h"


ThreadIpcHost::ThreadIpcHost(int lookupFreq,
			     bool start)
 : freq (lookupFreq)
{
	connect(&timer, SIGNAL(timeout()),
		this, SLOT(queueLookup()));
	if (start)
		startLookup();
}

ThreadIpcHost::~ThreadIpcHost()
{
	if (timer.isActive())
		stopLookup();
}

void ThreadIpcHost::stopLookup()
{
	timer.stop();
	queueLookup();
}

void ThreadIpcHost::queueMessage(const QByteArray &msg)
{
	mqLock.lock();
	mq.append(msg);
	mqLock.unlock();
}

void ThreadIpcHost::queueLookup()
{
	mqLock.lock();
	if (mq.isEmpty()) {
		mqLock.unlock();
		return;
	}
	QValueList<QByteArray>::iterator i = mq.begin(),
					 end = mq.end();
	for ( ; i != end; ++i)
		emit receivedMessage(*i);
	mq.clear();
	mqLock.unlock();
}

#include "ipc.moc"
