/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   KWallet DCOP Interface is                                             *
 *    Copyright (c) 2002-2003 George Staikos <staikos@kde.org>             *
 *   KWallet is part of the KDE libraries                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "kded_kwalletemu.h"
#include "kwalletemu_stub.h"
#include "kwalletemu_stub.cpp"
#include "globalstuff.h"

#include <kdatastream.h>
#include <kapplication.h>

#include <dcopclient.h>
#include <dcopref.h>


#define EMULATE_KWALLET_NAME	"kwalletd"
#define PWMANAGER_DCOP_APP	"pwmanager"
#define PWMANAGER_DCOP_OBJ	"kwalletemu"

#if defined(PWM_DEBUG) && KDED_KWALLETEMU_DEBUG != 0
# include <syslog.h>
# define prDbg(msg,x...)	do { \
	syslog(LOG_MAKEPRI(LOG_USER, LOG_ERR), "[PwManager KWalletEmu]: " msg, ##x); \
				} while (0)
#else
inline void prDbg(const char *, ...)	{ /* nothing */ }
#endif


extern "C"
{
	KDEDModule * create_pwmanager_kwalletemu(const QCString &)
	{
		return (new Kded_KWalletEmu(EMULATE_KWALLET_NAME));
	}
}


Kded_KWalletEmu::Kded_KWalletEmu(const QCString &name)
 : KDEDModule(name)
{
	dcopClient = kapp->dcopClient();
	stub = new KWalletEmu_stub(PWMANAGER_DCOP_APP, PWMANAGER_DCOP_OBJ);
	prDbg("initialized");
}

Kded_KWalletEmu::~Kded_KWalletEmu()
{
	delete stub;
}

QCString Kded_KWalletEmu::DCOPPeerName() const
{
	DCOPClient *dc = const_cast<Kded_KWalletEmu *>(this)->callingDcopClient();
	if (!dc)
		return "";
	return dc->senderId();
}

bool Kded_KWalletEmu::isEnabled() const
{
	return stub->isEnabled(DCOPPeerName());
}

int Kded_KWalletEmu::open(const QString& wallet,
			  uint wId)
{
	return stub->open(DCOPPeerName(),
			  wallet,
			  wId);
}

int Kded_KWalletEmu::openPath(const QString& path,
			      uint wId)
{
	return stub->openPath(DCOPPeerName(),
			      path,
			      wId);
}

void Kded_KWalletEmu::openAsynchronous(const QString& wallet,
				       const QCString& returnObject,
				       uint wId)
{
	stub->openAsynchronous(DCOPPeerName(),
			       wallet,
			       returnObject,
			       wId);
}

int Kded_KWalletEmu::close(const QString& wallet,
			   bool force)
{
	return stub->close(DCOPPeerName(),
			   wallet,
			   force);
}

int Kded_KWalletEmu::close(int handle,
			   bool force)
{
	return stub->close(DCOPPeerName(),
			   handle,
			   force);
}

ASYNC Kded_KWalletEmu::sync(int handle)
{
	stub->sync(DCOPPeerName(),
		   handle);
}

int Kded_KWalletEmu::deleteWallet(const QString& wallet)
{
	return stub->deleteWallet(DCOPPeerName(),
				  wallet);
}

bool Kded_KWalletEmu::isOpen(const QString& wallet) const
{
	return stub->isOpen(DCOPPeerName(),
			    wallet);
}

bool Kded_KWalletEmu::isOpen(int handle)
{
	return stub->isOpen(DCOPPeerName(),
			    handle);
}

QStringList Kded_KWalletEmu::users(const QString& wallet) const
{
	return stub->users(DCOPPeerName(),
			   wallet);
}

void Kded_KWalletEmu::changePassword(const QString& wallet,
				     uint wId)
{
	stub->changePassword(DCOPPeerName(),
			     wallet,
			     wId);
}

QStringList Kded_KWalletEmu::wallets() const
{
	return stub->wallets(DCOPPeerName());
}

QStringList Kded_KWalletEmu::folderList(int handle)
{
	return stub->folderList(DCOPPeerName(),
				handle);
}

bool Kded_KWalletEmu::hasFolder(int handle,
				const QString& folder)
{
	return stub->hasFolder(DCOPPeerName(),
			       handle,
			       folder);
}

bool Kded_KWalletEmu::createFolder(int handle,
				   const QString& folder)
{
	return stub->createFolder(DCOPPeerName(),
				  handle,
				  folder);
}

bool Kded_KWalletEmu::removeFolder(int handle,
				   const QString& folder)
{
	return stub->removeFolder(DCOPPeerName(),
				  handle,
				  folder);
}

QStringList Kded_KWalletEmu::entryList(int handle,
				       const QString& folder)
{
	return stub->entryList(DCOPPeerName(),
			       handle,
			       folder);
}

QByteArray Kded_KWalletEmu::readEntry(int handle,
				      const QString& folder,
				      const QString& key)
{
	return stub->readEntry(DCOPPeerName(),
			       handle,
			       folder,
			       key);
}

QByteArray Kded_KWalletEmu::readMap(int handle,
				    const QString& folder,
				    const QString& key)
{
	return stub->readMap(DCOPPeerName(),
			     handle,
			     folder,
			     key);
}

QString Kded_KWalletEmu::readPassword(int handle,
				      const QString& folder,
				      const QString& key)
{
	return stub->readPassword(DCOPPeerName(),
				  handle,
				  folder,
				  key);
}

int Kded_KWalletEmu::renameEntry(int handle,
				 const QString& folder,
				 const QString& oldName,
				 const QString& newName)
{
	return stub->renameEntry(DCOPPeerName(),
				 handle,
				 folder,
				 oldName,
				 newName);
}

int Kded_KWalletEmu::writeEntry(int handle,
				const QString& folder,
				const QString& key,
				const QByteArray& value,
				int entryType)
{
	return stub->writeEntry(DCOPPeerName(),
				handle,
				folder,
				key,
				value,
				entryType);
}

int Kded_KWalletEmu::writeEntry(int handle,
				const QString& folder,
				const QString& key,
				const QByteArray& value)
{
	return stub->writeEntry(DCOPPeerName(),
				handle,
				folder,
				key,
				value);
}

int Kded_KWalletEmu::writeMap(int handle,
			      const QString& folder,
			      const QString& key,
			      const QByteArray& value)
{
	return stub->writeMap(DCOPPeerName(),
			      handle,
			      folder,
			      key,
			      value);
}

int Kded_KWalletEmu::writePassword(int handle,
				   const QString& folder,
				   const QString& key,
				   const QString& value)
{
	return stub->writePassword(DCOPPeerName(),
				   handle,
				   folder,
				   key,
				   value);
}

bool Kded_KWalletEmu::hasEntry(int handle,
			       const QString& folder,
			       const QString& key)
{
	return stub->hasEntry(DCOPPeerName(),
			      handle,
			      folder,
			      key);
}

int Kded_KWalletEmu::entryType(int handle,
			       const QString& folder,
			       const QString& key)
{
	return stub->entryType(DCOPPeerName(),
			       handle,
			       folder,
			       key);
}

int Kded_KWalletEmu::removeEntry(int handle,
				 const QString& folder,
				 const QString& key)
{
	return stub->removeEntry(DCOPPeerName(),
				 handle,
				 folder,
				 key);
}

bool Kded_KWalletEmu::disconnectApplication(const QString& wallet,
					    const QCString& application)
{
	return stub->disconnectApplication(DCOPPeerName(),
					   wallet,
					   application);
}

void Kded_KWalletEmu::reconfigure()
{
	stub->reconfigure(DCOPPeerName());
}

bool Kded_KWalletEmu::folderDoesNotExist(const QString& wallet,
					 const QString& folder)
{
	return stub->folderDoesNotExist(DCOPPeerName(),
					wallet,
					folder);
}

bool Kded_KWalletEmu::keyDoesNotExist(const QString& wallet,
				      const QString& folder,
				      const QString& key)
{
	return stub->keyDoesNotExist(DCOPPeerName(),
				     wallet,
				     folder,
				     key);
}

void Kded_KWalletEmu::closeAllWallets()
{
	stub->closeAllWallets(DCOPPeerName());
}

bool Kded_KWalletEmu::isEmulated() const
{
	return true;
}

QString Kded_KWalletEmu::emulationApp() const
{
	return PWMANAGER_DCOP_APP;
}

ASYNC Kded_KWalletEmu::sig_walletClosed(const QString &wallet)
{
	prDbg("DCOP-signal: walletClosed QString");
	if (DCOPPeerName() != PWMANAGER_DCOP_APP) {
		prDbg("invalid peer!");
		return;
	}
	QByteArray b;
	QDataStream ds(b, IO_WriteOnly);
	ds << wallet;
	dcopClient->emitDCOPSignal(EMULATE_KWALLET_NAME,
				   "walletClosed(QString)", b);
}

ASYNC Kded_KWalletEmu::sig_walletClosed(int handle)
{
	prDbg("DCOP-signal: walletClosed int");
	if (DCOPPeerName() != PWMANAGER_DCOP_APP) {
		prDbg("invalid peer!");
		return;
	}
	QByteArray b;
	QDataStream ds(b, IO_WriteOnly);
	ds << handle;
	dcopClient->emitDCOPSignal(EMULATE_KWALLET_NAME,
				   "walletClosed(int)", b);
}

ASYNC Kded_KWalletEmu::sig_allWalletsClosed()
{
	prDbg("DCOP-signal: allWalletsClosed");
	if (DCOPPeerName() != PWMANAGER_DCOP_APP) {
		prDbg("invalid peer!");
		return;
	}
	dcopClient->emitDCOPSignal(EMULATE_KWALLET_NAME,
				   "allWalletClosed()", QByteArray());
}

ASYNC Kded_KWalletEmu::sig_applicationDisconnected(const QString &wallet,
						   const QCString &application)
{
	prDbg("DCOP-signal: applicationDisconnected");
	if (DCOPPeerName() != PWMANAGER_DCOP_APP) {
		prDbg("invalid peer!");
		return;
	}
	QByteArray b;
	QDataStream ds(b, IO_WriteOnly);
	ds << wallet;
	ds << application;
	dcopClient->emitDCOPSignal(EMULATE_KWALLET_NAME,
				   "applicationDisconnected(QString,QCString)", b);
}

ASYNC Kded_KWalletEmu::sig_folderUpdated(const QString &wallet,
					 const QString &folder)
{
	prDbg("DCOP-signal: folderUpdated");
	if (DCOPPeerName() != PWMANAGER_DCOP_APP) {
		prDbg("invalid peer!");
		return;
	}
	QByteArray b;
	QDataStream ds(b, IO_WriteOnly);
	ds << wallet;
	ds << folder;
	dcopClient->emitDCOPSignal(EMULATE_KWALLET_NAME,
				   "folderUpdated(QString,QString)", b);
}

ASYNC Kded_KWalletEmu::sig_folderListUpdated(const QString &wallet)
{
	prDbg("DCOP-signal: folderListUpdated");
	if (DCOPPeerName() != PWMANAGER_DCOP_APP) {
		prDbg("invalid peer!");
		return;
	}
	QByteArray b;
	QDataStream ds(b, IO_WriteOnly);
	ds << wallet;
	dcopClient->emitDCOPSignal(EMULATE_KWALLET_NAME,
				   "folderListUpdated(QString)", b);
}

ASYNC Kded_KWalletEmu::sig_walletListDirty()
{
	prDbg("DCOP-signal: walletListDirty");
	if (DCOPPeerName() != PWMANAGER_DCOP_APP) {
		prDbg("invalid peer!");
		return;
	}
	dcopClient->emitDCOPSignal(EMULATE_KWALLET_NAME,
				   "walletListDirty()", QByteArray());
}

ASYNC Kded_KWalletEmu::sig_walletCreated(const QString &wallet)
{
	prDbg("DCOP-signal: walletCreated");
	if (DCOPPeerName() != PWMANAGER_DCOP_APP) {
		prDbg("invalid peer!");
		return;
	}
	QByteArray b;
	QDataStream ds(b, IO_WriteOnly);
	ds << wallet;
	dcopClient->emitDCOPSignal(EMULATE_KWALLET_NAME,
				   "walletCreated(QString)", b);
}

ASYNC Kded_KWalletEmu::sig_walletOpened(const QString &wallet)
{
	prDbg("DCOP-signal: walletOpened");
	if (DCOPPeerName() != PWMANAGER_DCOP_APP) {
		prDbg("invalid peer!");
		return;
	}
	QByteArray b;
	QDataStream ds(b, IO_WriteOnly);
	ds << wallet;
	dcopClient->emitDCOPSignal(EMULATE_KWALLET_NAME,
				   "walletOpened(QString)", b);
}

ASYNC Kded_KWalletEmu::sig_walletDeleted(const QString &wallet)
{
	prDbg("DCOP-signal: walletDeleted");
	if (DCOPPeerName() != PWMANAGER_DCOP_APP) {
		prDbg("invalid peer!");
		return;
	}
	QByteArray b;
	QDataStream ds(b, IO_WriteOnly);
	ds << wallet;
	dcopClient->emitDCOPSignal(EMULATE_KWALLET_NAME,
				   "walletDeleted(QString)", b);
}

#include "kded_kwalletemu.moc"
