/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "listviewpwm.h"
#include "pwmexception.h"

#include <qpainter.h>
#include <qpixmap.h>

#include <kiconloader.h>


ListViewPwM::ListViewPwM(QWidget *parent, const char *name)
 : KListView(parent, name)
{
//	setResizeMode(QListView::AllColumns);
}

bool ListViewPwM::event(QEvent *e)
{
	if (e->type() == QEvent::LayoutHint)
		emit layoutChanged();
	return KListView::event(e);
}


QPixmap * ListViewItemPwM::onPix = 0;
QPixmap * ListViewItemPwM::offPix = 0;

ListViewItemPwM::ListViewItemPwM(QListView *parent)
 : QCheckListItem(parent, "", QCheckListItem::CheckBox)
{
	if (!onPix) {
		PWM_ASSERT(!offPix);
		KIconLoader il;
		static QPixmap onP(il.loadIcon("button_ok", KIcon::Small));
		onPix = &onP;
		static QPixmap offP(il.loadIcon("encrypted", KIcon::Small));
		offPix = &offP;
	}
}

void ListViewItemPwM::paintCell(QPainter *p, const QColorGroup &cg,
				int column, int width, int align)
{
	if (!p)
		return;
	if (column != 0) {
		QCheckListItem::paintCell(p, cg, column, width, align);
		return;
	}
	QPixmap *curPix = isOn() ? onPix : offPix;
	int pixSpace = curPix->width();
	pixSpace += 4;
	QRect window(p->viewport());
	// clear the rectangle (we have to clear it first. see QT doc)
	p->eraseRect(0, 0, pixSpace, window.height());
	// now draw the pixmap
	int y = (height() - curPix->height()) / 2;
	p->drawPixmap(1, y, *curPix);
	window.moveLeft(pixSpace);
	p->setViewport(window);
	QListViewItem::paintCell(p, cg, column, width - pixSpace, align);
}

#include "listviewpwm.moc"
