/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004, 2005  by Michael Buesch                           *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef PWMANAGER_MASTERKEY_SMARTKEY_CHIPCARD1_H_
#define PWMANAGER_MASTERKEY_SMARTKEY_CHIPCARD1_H_

#include "masterkey/smartkey/smartkey_backend.h"

#include <qcstring.h>


class CTCardTrader;
class CTCard;

class Chipcard1Interface : public ChipcardInterface
{
public:
	Chipcard1Interface();
	virtual ~Chipcard1Interface() { }

	/** Write data to the card. */
	virtual SmartKey_backend::Status write(const QByteArray &data);
	/** Read data from the card. */
	virtual SmartKey_backend::Status read(QByteArray *data);
	/** Erase the card. */
	virtual SmartKey_backend::Status erase();

protected:
	/** Open the card. */
	SmartKey_backend::Status ct_open();
	/** Close the card. */
	void ct_close();
	/** Write data to the card. */
	SmartKey_backend::Status ct_write(const QByteArray &data);
	/** Read data from the card. */
	SmartKey_backend::Status ct_read(QByteArray *data);
	/** Erase the card. */
	SmartKey_backend::Status ct_erase();

protected:
	CTCardTrader *ctTrader;
	CTCard *ctCard;
};

#endif // PWMANAGER_MASTERKEY_SMARTKEY_CHIPCARD1_H_
