/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003, 2004, 2005  by Michael Buesch                     *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef PWMTRAY_H_
#define PWMTRAY_H_

#include <ksystemtray.h>
#include <kpopupmenu.h>

#include <qptrlist.h>

#include "pwmexception.h"


class QPainter;
class PwMInit;
class PwMDoc;
class PwMTray;


class MenuItemDocInfo
{
public:
	MenuItemDocInfo(PwMDoc *_doc = 0, int _category = 0, int _entry = 0)
		 : doc (_doc)
		 , category (_category)
		 , entry (_entry)
		{ }
	/** pointer to the document associated with this active item. */
	PwMDoc *doc;
	/** category id for this item in the document. */
	int category;
	/** entry id for this item in the document. */
	int entry;
};

class QCustomMenuItem_QObject : public QCustomMenuItem
			      , public QObject
{
public:
	QCustomMenuItem_QObject() {}
};

class ActiveMenuItem : public QCustomMenuItem_QObject
{
	Q_OBJECT

public:
	enum Task
	{
		pwToClipboard,
		nameToClipboard,
		descToClipboard,
		urlToClipboard,
		launcherToClipboard,
		commentToClipboard,
		execLauncher,
		execLauncherAndCopy,
		goToURL,
		openMainWnd,
		closeDoc,
		lock,
		deepLock,
		unlock
	};

public:
	ActiveMenuItem(const QString &_text,
		       const QFont &_font,
		       Task _task,
		       PwMTray *_tray,
		       PwMDoc * _doc,
		       int _category,
		       int _entry);
	~ActiveMenuItem();

	void paint(QPainter *p, const QColorGroup &, bool,
		   bool, int x, int y, int w, int h);
	QSize sizeHint();
	bool fullSpan() const
			{ return false; }
	bool isSeparator() const
			{ return false; }
	void setFont(const QFont &f)
			{ font = f; }

public slots:
	/** this slot must be called, when the user clicks the ActiveMenuItem. */
	void execIt();

protected:
	/** pointer to the tray instance. */
	PwMTray *tray;
	/** text for the menu item. */
	QString text;
	/** font for "text". */
	QFont font;
	/** task to execute when this item is activated. */
	Task task;
	/** document related data. */
	MenuItemDocInfo docInfo;
};

class ActiveMenu : public KPopupMenu
{
	Q_OBJECT

protected:
	enum Type
	{
		type_unknown,
		type_documentRoot,
		type_category,
		type_entry
	};

public:
	ActiveMenu(PwMTray *_tray, QWidget *parent = 0, const char *name = 0);
	~ActiveMenu();

	void setTypeDocRoot(PwMDoc *_doc)
		{
			type = type_documentRoot;
			docInfo.doc = _doc;
		}
	void setTypeCategory(PwMDoc *_doc, int _category)
		{
			type = type_category;
			docInfo.doc = _doc;
			docInfo.category = _category;
		}
	void setTypeEntry(PwMDoc *_doc, int _category, int _entry)
		{
			type = type_entry;
			docInfo.doc = _doc;
			docInfo.category = _category;
			docInfo.entry = _entry;
		}

protected:
	void hideEvent(QHideEvent *e);
	void appendCategoryList();
	void appendEntryList();
	void appendEntryMenu();
	void appendMainWndCtrl();
	void sortList(const QStringList &in,
		      QValueList< QPair<QString, unsigned int> > *out);

protected slots:
	void constructContent();
	void destructContent();

protected:
	/** pointer to the tray instance. */
	PwMTray *tray;
	/** menu type. */
	Type type;
	/** document related data. */
	MenuItemDocInfo docInfo;
};

/** tray icon implementation */
class PwMTray : public KSystemTray
{
	Q_OBJECT

	friend class ActiveMenuItem;

public: 
	PwMTray(PwMInit *_init, QWidget* parent = 0, const char* name = 0);
	~PwMTray();

	/** connect all signals for this document to the tray */
	void connectDocToTray(PwMDoc *doc);

public slots:
	/** for update-notification from all open documents */
	void updateTree(PwMDoc *document);
	/** when a document has been closed, call this func
	  * to delete its tray-entry
	  */
	void closeTreeEntry(PwMDoc *document);

protected slots:
	/** someone requested the context menu. We must set it up. Hop-Hop! */
	void aboutToShowCtxMenu();
	/** context menu hidden. */
	void aboutToHideCtxMenu();
	/** open a new document */
	void openDoc();
	/** open a new mainwnd */
	void newMainWnd();
	/** undock this tray icon */
	void undock();
	/** generate a password */
	void genPassword();
	/** destroy all document menus. */
	void destroyDocMenus();

signals:
	/** this icon got deleted */
	void closed(PwMTray *);
	/** the user clicked on the tray icon */
	void clickedIcon(PwMTray *);

protected:
	/** list of KPopupMenu context entries for every open document. */
	QPtrList<ActiveMenu> docMenuList;
	/** pointer to init */
	PwMInit *init;
	/** pointer to the context menu root. */
	KPopupMenu *ctxMenu;

protected:
	/** build the main menu-items */
	void buildMain();
	/** build the document menus. */
	void buildDocMenus();
	/** append a new doc menu. */
	void appendDocMenu(PwMDoc *doc);
	/** mouse event on icon */
	void mouseReleaseEvent(QMouseEvent *e);
};

#endif // PWMTRAY_H_
