/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "pwmviewstyle_1.h"
#include "pwmview.h"
#include "listviewpwm.h"
#include "commentbox.h"

#include <klocale.h>

#define INITIAL_CATEGORIES_WIDTH	100

PwMViewStyle_1::PwMViewStyle_1(PwMView *view)
 : QObject()
{
	splitter = new QSplitter(view);
	vbox1 = new QVBox(splitter);
	categoriesTitle = new QLabel(vbox1);
	categoriesList = new QListBox(vbox1);
	splitter2 = new QSplitter(splitter);
	splitter2->setOrientation(Qt::Vertical);
	lv = new ListViewPwM(splitter2);
	commentBox = new CommentBox(splitter2);
	// set sizes and styles
	commentBox->resize(commentBox->size().width(), 60);
	QValueList<int> sizes;
	sizes.push_back(INITIAL_CATEGORIES_WIDTH);
	sizes.push_back(view->height() - INITIAL_CATEGORIES_WIDTH);
	splitter->setSizes(sizes);
	categoriesTitle->setAlignment(Qt::AlignHCenter);
	categoriesTitle->setFrameShape(QFrame::MenuBarPanel);
	categoriesTitle->setText(i18n("Categories:"));
	catCtxMenu = new QPopupMenu(view);
	catCtxMenu->insertItem(i18n("&Rename"),
			       view, SLOT(renCatButton_slot()));
	catCtxMenu->insertItem(i18n("&Delete"),
			       view, SLOT(delCatButton_slot()));
	// connections
	connect(categoriesList, SIGNAL(highlighted(int)),
		view, SLOT(shiftToView()));
	connect(categoriesList,
		SIGNAL(rightButtonClicked(QListBoxItem *, const QPoint &)),
		this,
		SLOT(catRightClick(QListBoxItem *, const QPoint &)));
}

PwMViewStyle_1::~PwMViewStyle_1()
{
	delete catCtxMenu;
	delete commentBox;
	delete splitter;
}

void PwMViewStyle_1::catRightClick(QListBoxItem *item, const QPoint &point)
{
	if (!item)
		return;
	catCtxMenu->move(point);
	catCtxMenu->show();
}

void PwMViewStyle_1::delCategory(const QString &cat)
{
	PWM_ASSERT(categoriesList);
	int i, count = categoriesList->count();
	for (i = 0; i < count; ++i) {
		if (categoriesList->text(i) == cat) {
			categoriesList->removeItem(i);
			return;
		}
	}
	BUG();
}

void PwMViewStyle_1::selectCategory(const QString &cat)
{
	PWM_ASSERT(categoriesList);
	int i, count = categoriesList->count();
	for (i = 0; i < count; ++i) {
		if (categoriesList->text(i) == cat) {
			categoriesList->setCurrentItem(i);
			return;
		}
	}
	// fall back to 0
	categoriesList->setCurrentItem(0);
}

#include "pwmviewstyle_1.moc"
