/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef PWMVIEWSTYLE_1_H
#define PWMVIEWSTYLE_1_H

#include <qsplitter.h>
#include <qvbox.h>
#include <qtextedit.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qpopupmenu.h>

class PwMView;
class ListViewPwM;
class CommentBox;

class PwMViewStyle_1 : public QObject
{
	Q_OBJECT
public:
	PwMViewStyle_1(PwMView *view);
	~PwMViewStyle_1();

	ListViewPwM * getLv()
			{ return lv; }
	CommentBox * getCommentBox()
			{ return commentBox; }

	/** returns the currently selected category */
	QString getCurrentCategory()
			{ return categoriesList->currentText(); }
	/** add Category to the view */
	void addCategory(const QString &cat)
			{ categoriesList->insertItem(cat); }
	/** delete Category from view */
	void delCategory(const QString &cat);
	/** delete all categories from view */
	void delAllCategories()
			{ categoriesList->clear(); }
	/** select the specified category */
	void selectCategory(const QString &cat);
	/** returns the number of categories in this view.
	  * This value dosn't say anything about the number of
	  * categories in the document.
	  */
	int numCategories()
			{ return categoriesList->count(); }
	/** resize the view */
	void resize(const QSize &size)
			{ splitter->resize(size); }

protected slots:
	/** user clicked right button in category list */
	void catRightClick(QListBoxItem *item, const QPoint &point);

protected:
	/** main list view */
	ListViewPwM *lv;
	/** main splitter widget */
	QSplitter *splitter;
	/** commentTextEdit splitter */
	QSplitter *splitter2;
	/** categories list-box */
	QListBox *categoriesList;
	/** title string for the categories combo or list box */
	QLabel *categoriesTitle;
	/** hbox1 for widget style */
	QVBox *vbox1;
	/** text-edit to display the comment */
	CommentBox *commentBox;
	/** category list context menu */
	QPopupMenu *catCtxMenu;
};

#endif
