/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003, 2004 by Michael Buesch                            *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "waitwnd.h"
#include "pwmexception.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>

#include <klocale.h>


WaitWnd::WaitWnd(QString caption, QString _staticText,
		 bool showCancelButton, bool showGenericText,
		 QWidget *parent,
		 const char *name, bool modal, WFlags f)
 : QDialog(parent, name, modal, f)
 , genericText (0)
 , cancelButton (0)
{
	layout = new QVBoxLayout(this, 11, 15);

	staticText = new QLabel(this);
	staticText->setText(_staticText);
	staticText->setAlignment(Qt::AlignHCenter | Qt::WordBreak);
	layout->addWidget(staticText);

	if (showGenericText) {
		genericText = new QLabel(this);
		genericText->setAlignment(Qt::AlignHCenter | Qt::WordBreak);
		layout->addWidget(genericText);
	}
	if (showCancelButton) {
		cancelButton = new QPushButton(this);
		cancelButton->setText(i18n("&Cancel"));
		connect(cancelButton, SIGNAL(clicked()),
			this, SLOT(cancelButton_slot()));
		layout->addWidget(cancelButton);
	}

	setCaption(caption);
	resize(QSize(300, 150).expandedTo(minimumSizeHint()));
}

WaitWnd::~WaitWnd()
{
}

void WaitWnd::close()
{
	if (!cancelButton) {
		// This is magic...
		cancelButton = reinterpret_cast<QPushButton *>(1);
	}
	QDialog::close();
}

void WaitWnd::closeEvent(QCloseEvent *e)
{
	if (!cancelButton) {
		e->ignore();
		return;
	}
	e->accept();
	emit closing();
}

void WaitWnd::cancelButton_slot()
{
	close();
}

void WaitWnd::setGenericText(const QString &text)
{
	if (genericText)
		genericText->setText(text);
}

#include "waitwnd.moc"
