//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;

	/// <remarks>
	///  The KNTLM class is useful for creating the authentication structures which 
	///  can be used for various servers which implements NTLM type authentication.
	///  A comprehensive description of the NTLM authentication protocol can be found
	///  at http://davenport.sourceforge.net/ntlm.html
	///  The class also contains methods to create the LanManager and NT (MD4) hashes
	///  of a password. 
	///  This class doesn't maintain any state information, so all methods are static.
	///  </remarks>		<short> KNTLM class implements the NTLM authentication protocol. </short>

	[SmokeClass("KNTLM")]
	public class KNTLM : Object, IDisposable {
		protected SmokeInvocation interceptor = null;
		private IntPtr smokeObject;
		protected KNTLM(Type dummy) {}
		protected void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KNTLM), this);
		}
		private static SmokeInvocation staticInterceptor = null;
		static KNTLM() {
			staticInterceptor = new SmokeInvocation(typeof(KNTLM), null);
		}
		public enum Flags {
			Negotiate_Unicode = 0x00000001,
			Negotiate_OEM = 0x00000002,
			Request_Target = 0x00000004,
			Negotiate_Sign = 0x00000010,
			Negotiate_Seal = 0x00000020,
			Negotiate_Datagram_Style = 0x00000040,
			Negotiate_LM_Key = 0x00000080,
			Negotiate_Netware = 0x00000100,
			Negotiate_NTLM = 0x00000200,
			Negotiate_Domain_Supplied = 0x00001000,
			Negotiate_WS_Supplied = 0x00002000,
			Negotiate_Local_Call = 0x00004000,
			Negotiate_Always_Sign = 0x00008000,
			Target_Type_Domain = 0x00010000,
			Target_Type_Server = 0x00020000,
			Target_Type_Share = 0x00040000,
			Negotiate_NTLM2_Key = 0x00080000,
			Request_Init_Response = 0x00100000,
			Request_Accept_Response = 0x00200000,
			Request_NonNT_Key = 0x00400000,
			Negotiate_Target_Info = 0x00800000,
			Negotiate_128 = 0x20000000,
			Negotiate_Key_Exchange = 0x40000000,
			Negotiate_56 = 0x80000000,
		}
		public enum AuthFlag {
			Force_V1 = 0x1,
			Force_V2 = 0x2,
			Add_LM = 0x4,
		}
		public KNTLM() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KNTLM", "KNTLM()", typeof(void));
		}
		~KNTLM() {
			interceptor.Invoke("~KNTLM", "~KNTLM()", typeof(void));
		}
		public void Dispose() {
			interceptor.Invoke("~KNTLM", "~KNTLM()", typeof(void));
		}
		/// <remarks>
		///  Creates the initial message (type 1) which should be sent to the server.
		/// <param> name="negotiate" - a buffer where the Type 1 message will returned.
		/// </param><param> name="domain" - the domain name which should be send with the message.
		/// </param><param> name="workstation" - the workstation name which should be send with the message.
		/// </param><param> name="flags" - various flags, in most cases the defaults will good.
		/// </param></remarks>		<return> true if creating the structure succeeds, false otherwise.   
		///    </return>
		/// 		<short>    Creates the initial message (type 1) which should be sent to the server.</short>
		public static bool GetNegotiate(QByteArray negotiate, string domain, string workstation, uint flags) {
			return (bool) staticInterceptor.Invoke("getNegotiate#$$$", "getNegotiate(QByteArray&, const QString&, const QString&, quint32)", typeof(bool), typeof(QByteArray), negotiate, typeof(string), domain, typeof(string), workstation, typeof(uint), flags);
		}
		public static bool GetNegotiate(QByteArray negotiate, string domain, string workstation) {
			return (bool) staticInterceptor.Invoke("getNegotiate#$$", "getNegotiate(QByteArray&, const QString&, const QString&)", typeof(bool), typeof(QByteArray), negotiate, typeof(string), domain, typeof(string), workstation);
		}
		public static bool GetNegotiate(QByteArray negotiate, string domain) {
			return (bool) staticInterceptor.Invoke("getNegotiate#$", "getNegotiate(QByteArray&, const QString&)", typeof(bool), typeof(QByteArray), negotiate, typeof(string), domain);
		}
		public static bool GetNegotiate(QByteArray negotiate) {
			return (bool) staticInterceptor.Invoke("getNegotiate#", "getNegotiate(QByteArray&)", typeof(bool), typeof(QByteArray), negotiate);
		}
		/// <remarks>
		///  Creates the type 3 message which should be sent to the server after 
		///  the challenge (type 2) received.
		/// <param> name="auth" - a buffer where the Type 3 message will returned.
		/// </param><param> name="challenge" - the Type 2 message returned by the server.
		/// </param><param> name="user" - user's name.
		/// </param><param> name="password" - user's password.
		/// </param><param> name="domain" - the target domain. If left empty, it will be extracted 
		///  from the challenge.
		/// </param><param> name="workstation" - the user's workstation.
		/// </param><param> name="authflags" - AuthFlags flags that changes the response generation behavior.
		///  Force_V1 or Force_V2 forces (NT)LMv1 or (NT)LMv2 responses generation, otherwise it's
		///  autodetected from the challenge. Add_LM adds LMv1 or LMv2 responses additional to the 
		///  NTLM response.
		/// </param></remarks>		<return> true if auth filled with the Type 3 message, false if an error occurred 
		///  (challenge data invalid, NTLMv2 authentication forced, but the challenge data says
		///  no NTLMv2 supported, or no NTLM supported at all, and Add_LM not specified).
		///    </return>
		/// 		<short>    Creates the type 3 message which should be sent to the server after   the challenge (type 2) received.</short>
		public static bool GetAuth(QByteArray auth, QByteArray challenge, string user, string password, string domain, string workstation, uint authflags) {
			return (bool) staticInterceptor.Invoke("getAuth##$$$$$", "getAuth(QByteArray&, const QByteArray&, const QString&, const QString&, const QString&, const QString&, KNTLM::AuthFlags)", typeof(bool), typeof(QByteArray), auth, typeof(QByteArray), challenge, typeof(string), user, typeof(string), password, typeof(string), domain, typeof(string), workstation, typeof(uint), authflags);
		}
		public static bool GetAuth(QByteArray auth, QByteArray challenge, string user, string password, string domain, string workstation) {
			return (bool) staticInterceptor.Invoke("getAuth##$$$$", "getAuth(QByteArray&, const QByteArray&, const QString&, const QString&, const QString&, const QString&)", typeof(bool), typeof(QByteArray), auth, typeof(QByteArray), challenge, typeof(string), user, typeof(string), password, typeof(string), domain, typeof(string), workstation);
		}
		public static bool GetAuth(QByteArray auth, QByteArray challenge, string user, string password, string domain) {
			return (bool) staticInterceptor.Invoke("getAuth##$$$", "getAuth(QByteArray&, const QByteArray&, const QString&, const QString&, const QString&)", typeof(bool), typeof(QByteArray), auth, typeof(QByteArray), challenge, typeof(string), user, typeof(string), password, typeof(string), domain);
		}
		public static bool GetAuth(QByteArray auth, QByteArray challenge, string user, string password) {
			return (bool) staticInterceptor.Invoke("getAuth##$$", "getAuth(QByteArray&, const QByteArray&, const QString&, const QString&)", typeof(bool), typeof(QByteArray), auth, typeof(QByteArray), challenge, typeof(string), user, typeof(string), password);
		}
		/// <remarks>
		///  Returns the LanManager response from the password and the server challenge.
		///    </remarks>		<short>    Returns the LanManager response from the password and the server challenge.</short>
		public static QByteArray GetLMResponse(string password, ushort challenge) {
			return (QByteArray) staticInterceptor.Invoke("getLMResponse$$", "getLMResponse(const QString&, const unsigned char*)", typeof(QByteArray), typeof(string), password, typeof(ushort), challenge);
		}
		/// <remarks>
		///  Calculates the LanManager hash of the specified password.
		///    </remarks>		<short>    Calculates the LanManager hash of the specified password.</short>
		public static QByteArray LmHash(string password) {
			return (QByteArray) staticInterceptor.Invoke("lmHash$", "lmHash(const QString&)", typeof(QByteArray), typeof(string), password);
		}
		/// <remarks>
		///  Calculates the LanManager response from the LanManager hash and the server challenge.
		///    </remarks>		<short>    Calculates the LanManager response from the LanManager hash and the server challenge.</short>
		public static QByteArray LmResponse(QByteArray hash, ushort challenge) {
			return (QByteArray) staticInterceptor.Invoke("lmResponse#$", "lmResponse(const QByteArray&, const unsigned char*)", typeof(QByteArray), typeof(QByteArray), hash, typeof(ushort), challenge);
		}
		/// <remarks>
		///  Returns the NTLM response from the password and the server challenge.
		///    </remarks>		<short>    Returns the NTLM response from the password and the server challenge.</short>
		public static QByteArray GetNTLMResponse(string password, ushort challenge) {
			return (QByteArray) staticInterceptor.Invoke("getNTLMResponse$$", "getNTLMResponse(const QString&, const unsigned char*)", typeof(QByteArray), typeof(string), password, typeof(ushort), challenge);
		}
		/// <remarks>
		///  Returns the NTLM hash (MD4) from the password.
		///    </remarks>		<short>    Returns the NTLM hash (MD4) from the password.</short>
		public static QByteArray NtlmHash(string password) {
			return (QByteArray) staticInterceptor.Invoke("ntlmHash$", "ntlmHash(const QString&)", typeof(QByteArray), typeof(string), password);
		}
		/// <remarks>
		///  Calculates the NTLMv2 response.
		///    </remarks>		<short>    Calculates the NTLMv2 response.</short>
		public static QByteArray GetNTLMv2Response(string target, string user, string password, QByteArray targetInformation, ushort challenge) {
			return (QByteArray) staticInterceptor.Invoke("getNTLMv2Response$$$#$", "getNTLMv2Response(const QString&, const QString&, const QString&, const QByteArray&, const unsigned char*)", typeof(QByteArray), typeof(string), target, typeof(string), user, typeof(string), password, typeof(QByteArray), targetInformation, typeof(ushort), challenge);
		}
		/// <remarks>
		///  Calculates the LMv2 response.
		///    </remarks>		<short>    Calculates the LMv2 response.</short>
		public static QByteArray GetLMv2Response(string target, string user, string password, ushort challenge) {
			return (QByteArray) staticInterceptor.Invoke("getLMv2Response$$$$", "getLMv2Response(const QString&, const QString&, const QString&, const unsigned char*)", typeof(QByteArray), typeof(string), target, typeof(string), user, typeof(string), password, typeof(ushort), challenge);
		}
		/// <remarks>
		///  Returns the NTLMv2 hash.
		///    </remarks>		<short>    Returns the NTLMv2 hash.</short>
		public static QByteArray Ntlmv2Hash(string target, string user, string password) {
			return (QByteArray) staticInterceptor.Invoke("ntlmv2Hash$$$", "ntlmv2Hash(const QString&, const QString&, const QString&)", typeof(QByteArray), typeof(string), target, typeof(string), user, typeof(string), password);
		}
		/// <remarks>
		///  Calculates the LMv2 response.
		///    </remarks>		<short>    Calculates the LMv2 response.</short>
		public static QByteArray Lmv2Response(QByteArray hash, QByteArray clientData, ushort challenge) {
			return (QByteArray) staticInterceptor.Invoke("lmv2Response##$", "lmv2Response(const QByteArray&, const QByteArray&, const unsigned char*)", typeof(QByteArray), typeof(QByteArray), hash, typeof(QByteArray), clientData, typeof(ushort), challenge);
		}
	}
}
