#
# Find the MLT++ includes and library
#


FIND_PATH(LIBMLTPLUS_INCLUDE_DIR 
  NAMES mlt++/Mlt.h
  PATHS ${MLT_PATH}/include /usr/local/include /usr/include
  NO_DEFAULT_PATH
)

MESSAGE(STATUS "Found MLT++ INCLUDES: ${LIBMLTPLUS_INCLUDE_DIR}")

FIND_LIBRARY(LIBMLTPLUS_LIBRARY
  NAMES mlt++
  PATHS ${MLT_PATH}/lib /usr/lib /usr/local/lib
  NO_DEFAULT_PATH
)

MESSAGE(STATUS "Found MLT++ LIBR: ${LIBMLTPLUS_LIBRARY}")

IF (LIBMLTPLUS_LIBRARY AND LIBMLTPLUS_INCLUDE_DIR)
  SET( LIBMLTPLUS_FOUND 1 )
  SET( LIBMLTPLUS_LIBRARIES ${LIBMLTPLUS_LIBRARY} )
ELSE (LIBMLTPLUS_LIBRARY AND LIBMLTPLUS_INCLUDE_DIR)
  SET( LIBMLTPLUS_FOUND 0 )
ENDIF (LIBMLTPLUS_LIBRARY AND LIBMLTPLUS_INCLUDE_DIR)

IF (LIBMLTPLUS_FOUND)
  IF (NOT LIBMLTPLUS_FIND_QUIETLY)
    MESSAGE(STATUS "Found MLT++ library: ${LIBMLTPLUS_LIBRARY}")
  ENDIF (NOT LIBMLTPLUS_FIND_QUIETLY)
ELSE (LIBMLTPLUS_FOUND)
  IF (LIBMLTPLUS_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "Could not find MLT++ library")
  ENDIF (LIBMLTPLUS_FIND_REQUIRED)
ENDIF (LIBMLTPLUS_FOUND)

