/*
 *   kmoon - a moon phase indicator
 *   Copyright 1998,2000  Stephan Kulow <coolo@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

#ifndef KMOONAPPLET
#define KMOONAPPLET

#include <QtGui/QWidget>
#include <QtGui/QImage>
#include <QtGui/QMouseEvent>
#include <QtCore/QTimerEvent>

#include <sys/types.h>
#include <time.h>

#include <k3panelapplet.h>

// #include "kmoonwidget.h"

class QMenu;

class MoonWidget;

class MoonPAWidget : public K3PanelApplet
{
    Q_OBJECT

public:
    explicit MoonPAWidget(const QString& configFile, K3PanelApplet::Type t = K3PanelApplet::Normal, int actions = 0,
		 QWidget *parent = 0, const char *name = 0);
    ~MoonPAWidget();

    int widthForHeight(int height) const { return height; }
    int heightForWidth(int width) const { return width; }

protected:
    QMenu *popup;
    MoonWidget *moon;
    QString tooltip;

    void about() { showAbout(); }
    void preferences() { settings(); }

protected slots:

    void timerEvent( QTimerEvent *e);
    void showAbout();
    void settings();

protected:
    void mousePressEvent( QMouseEvent *e);
};

#endif
