// -*- c++ -*-
/***************************************************************************
                           kdetvformatconversion.h
                           -----------------------
    begin                : Sun Aug 1 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef KDETVFORMATCONVERSION_H
#define KDETVFORMATCONVERSION_H

// calling convention:
//   lineLength = pixels per line
//   numLines   = amount of lines
//   *Stride    = gap _between_ two lines (in bytes)

class KdetvFormatConversion
{
public:
    static void bgr24_to_yuyv(unsigned char* rgb, unsigned char* yuv, unsigned int lineLength,
                              unsigned int numLines, unsigned int rgbStride=0, unsigned int yuvStride=0);

    static void bgr32_to_yuyv(unsigned char* rgb, unsigned char* yuv, unsigned int lineLength,
                              unsigned int numLines, unsigned int rgbStride=0, unsigned int yuvStride=0);

    static void yuv420p_to_yuyv(unsigned char* yuv420p, unsigned char* yuv, unsigned int lineLength,
                                unsigned int numLines, unsigned int yuv420pStride=0, unsigned int yuvStride=0);
};

#endif //KDETVFORMATCONVERSION_H
