/***************************************************************************
                           none.cpp
                           --------
    begin                : Fri Aug 6 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <klocale.h>

#include "none.h"
#include "kdetvimagefilter.h"

class NoneImageFilter : public KdetvImageFilter
{
public:
    NoneImageFilter()
        : KdetvImageFilter(i18n("None"))
    {
        _fullFrameRate = false;
    }

    virtual ~NoneImageFilter()
    {
    }

    virtual KdetvImageFilterContext* operator<< (KdetvImageFilterContext* ctx)
    {
        return ctx;
    }

    virtual KdetvImage::ImageFormat inputFormats()
    {
        return KdetvImage::FORMAT_ALL;
    };
};

// -----------------------------------------------------------------------

NonePlugin::NonePlugin(Kdetv *ktv, const QString& cfgkey, QObject *parent, const char* name)
    : KdetvFilterPlugin(ktv, cfgkey, parent, name)
{
    _filter = new NoneImageFilter();
}

NonePlugin::~NonePlugin()
{
    delete _filter;
}

extern "C" {
    NonePlugin* create_none(Kdetv* ktv)
    {
        return new NonePlugin(ktv, "deinterlace-none", 0, "No deinterlacefilter");
    }
}

#include "none.moc"
