// -*- c++ -*-
/***************************************************************************
                           channeldb.h
                           -----------
    begin                : Sat Apr 10 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __CHANNELDB_H
#define __CHANNELDB_H

#include <qobject.h>
#include <qstring.h>
#include <qptrlist.h>
#include <qstringlist.h>
#include <qcstring.h>

#include <kurl.h>
#include <kio/job.h>

class ChannelStore;
class QDomElement;
class QBuffer;

class ChannelSuiteDbEntry
{
public:
    ChannelSuiteDbEntry();

    const QString& country() const { return _country; }
    const QString& region()  const { return _region;  }
    const QString& type()    const { return _type;    }
    const QString& comment() const { return _comment; }


private:
    friend class ChannelSuiteDb;

    QString _country;
    QString _region;
    QString _type;
    QString _comment;
    KURL    _url;
};

typedef QPtrList<ChannelSuiteDbEntry> ChannelSuiteDbEntryList;

class ChannelSuiteDb : public QObject
{
    Q_OBJECT

public:
    ChannelSuiteDb();
    virtual ~ChannelSuiteDb();

    void loadIndex(const KURL& url);
    const QStringList& getCountries() const { return _countries; }
    const QStringList& getRegions()   const { return _regions;   }
    const QStringList& getTypes()     const { return _types;     }
    ChannelSuiteDbEntryList* getEntries(const QString& country = QString::null,
                                        const QString& region  = QString::null,
                                        const QString& type    = QString::null);
    void importList(ChannelStore& store, ChannelSuiteDbEntry& e);


signals:
    void loadDone(bool success);
    void importDone(bool success);


private slots:
    void indexDataArrived(KIO::Job*, const QByteArray&);
    void indexDataResult(KIO::Job*);

    void importDataArrived(KIO::Job*, const QByteArray&);
    void importDataResult(KIO::Job*);


private:
    ChannelSuiteDbEntryList _entries;
    QStringList             _countries;
    QStringList             _regions;
    QStringList             _types;

    QBuffer*                _indexBuf;
    QBuffer*                _importBuf;

    ChannelStore*           _importStore;
};

#endif

// vim: ts=4 sw=4 et
