/***************************************************************************
                          popup.h  -  description
                             -------------------
    begin                : Tue Jul 17 2001
    copyright            : (C) 2001-2003 by Aurelien Jarno
    email                : aurelien@aurel32.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**
  *@author Aurelien Jarno
  */

#ifndef POPUP_H
#define POPUP_H

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

// includes files for Qt
#include <qwidget.h>
#include <qfont.h>

class Popup : public QWidget
{
   Q_OBJECT
public:
	Popup(QWidget *parent=0, const char *name=0);
	~Popup();

	void setText(const QString text);
	void setFont(const QFont font);

private:

	void paintEvent(QPaintEvent *);
	void mousePressEvent(QMouseEvent *);
	void mouseReleaseEvent(QMouseEvent *);
	void mouseMoveEvent(QMouseEvent *);
	void autoResize();

	int relX, relY;

	bool isDragged;

	QFont popupFont;
	QString popupText;

signals:

	void clicked(void);
	void savePos(void);
};

#endif

