#!/usr/bin/env python
# -*- coding: utf-8 -*-
# keyjnotegui install script
license = """\
Copyright (c) 2007 Sebastian Wiesner

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA."""


long_description = """\
A KDE frontend to KeyJnote. KeyJnote is a somewhat different presentation
programm. It uses OpenGL to presents some cool visual effects during
presentation.  More useful, but not less eye-candy are the zoom mode and the
highlighting features.
Much of the behaviour of KeyJnote is controlled by command line
switches. KeyJnoteGUI provides a nice KDE frontend to KeyJnote,
which gives you control about the most widely used switches.
Now you can watch cool presentations without moving down to
command line."""


sources = ['src/keyjnotegui.py',
           'src/kjnguiwidgets.py',
           'src/kjnwrapper.py',
           'src/presentationwidget.ui',
           'src/settings.py',
           'src/settingswidget.ui']


import kooldistutils


def get_version():
    filename = 'src/keyjnotegui.py'
    stream = open(filename)
    for line in stream:
        if line.startswith('__version__'):
            stream.close()
            exec line
            return __version__
        elif line.startswith('import'):
            raise SystemExit('Couldn\'t extract version information')


kooldistutils.setup(
    name='keyjnotegui',
    version=get_version(),
    description='A KDE frontend to KeyJnote',
    long_description=long_description,
    author='Sebastian \'lunar\' Wiesner',
    author_email='basti.wiesner@gmx.net',
    url='http://keyjnotegui.berlios.de',
    license=license,
    min_kde_version='3.5',
    min_qt_version='3.3',
    links=[('keyjnotegui', 'keyjnotegui.py')],
    sources=sources,
    desktop=['keyjnotegui.desktop'],
    manpages=['keyjnotegui.1'],
    data_files=[('share/pixmaps', ['icon/keyjnotegui.xpm'])],
    icons=[('hicolor',
            {'apps': [('icon/keyjnotegui-16x16.png', '16x16',
                       'keyjnotegui.png'),
                      ('icon/keyjnotegui-22x22.png', '22x22',
                       'keyjnotegui.png'),
                      ('icon/keyjnotegui-32x32.png', '32x32',
                       'keyjnotegui.png'),
                      ('icon/keyjnotegui-48x48.png', '48x48',
                       'keyjnotegui.png'),
                      ('icon/keyjnotegui.svgz', 'scalable',
                       'keyjnotegui.svgz')
                      ]}
            )]
    )
