/***************************************************************************
                          kfmenddate.h  -  description
                             -------------------
    begin                : Thu Sep 6 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFMENDDATE_H
#define KFMENDDATE_H

#include <qdatetime.h>

#include <qobject.h>

/**Model class representing an end date
  *@author Jeffrey Yu
  */

class KFMEndDate : public QObject  {
		Q_OBJECT
public: 
	KFMEndDate();
	KFMEndDate(const KFMEndDate* original);
	~KFMEndDate();
	
	/** Initialize the enddate from a prototype
			@param endDate Prototype enddate
		*/
	void endDate(const KFMEndDate* endDate);
	
	int operator<(const KFMEndDate& other);
	int operator==(const KFMEndDate& other);
	
	enum Type { NotADate, Absolute };
	
	/** Retrieve the enddate's type
			@return Type of enddate
		*/
	Type type() const;
	
	/** Set the enddate's type.
			@param type Type of enddate
		*/
	void type(const Type type);
		
		
	/** Retrieve the enddate's absolute date
			@return Absolute date for the enddate
		*/
	QDate date() const;
	
	/** Set the absolute date for the enddate
			@param date Absolute date
		*/
	void date(const QDate date);
	
	/** Retrieve the eta for this enddate
			@return Eta in days
		*/
	int eta() const;
	
signals:
	/** Signal sent when the contents of the enddate change. */
	void contentsChanged();
	
private:
	Type type_;
	QDate date_;
	
	
};

#endif
