#-
# Copyright (c) 2002 KIYOHARA Takashi <kiyohara@kk.iij4u.or.jp>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $FreeBSD: src/sys/pc98/pc98/canbus_if.m,v 1.2.8.1 2005/01/31 23:26:48 imp Exp $
#

#include <sys/bus.h>

INTERFACE canbus;

#
# CanBe I/O read
#
METHOD u_int8_t read {
	device_t		dev;
	device_t		child;
	int			reg;
};

#
# CanBe I/O write
#
METHOD void write {
	device_t		dev;
	device_t		child;
	int			reg;
	u_int8_t		val;
};

#
# CanBe I/O write multi bytes
#
METHOD void write_multi {
	device_t		dev;
	device_t		child;
	int			reg;
	const int		count;
	const u_int8_t *	vals;
};

#
# CanBe I/O delay
#
METHOD void delay {
	device_t		dev;
	device_t		child;
};
