/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2004 by the KFTPGrabber developers
 * Copyright (C) 2004 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#include "desencryptor.h"

#include <kmdcodec.h>
#include <qfile.h>

namespace KFTPGrabberBase {

DESEncryptor::DESEncryptor()
{
}

void DESEncryptor::DESExec(const QString &str, int mode)
{
  QCString string(str.ascii());
  m_output = "";
  
  QByteArray in;
  QByteArray out;
  
  if (mode == DES_DECRYPT) {
    // Base64 decode the output
    KCodecs::base64Decode(string, in);
  } else {
    in.resize(string.size());
    memcpy(in.data(), string.data(), in.size());
  }
  
  // Read 8 chars at a time and encrypt/decrypt them
  unsigned int i = 0;
  char *o_message = (char*) malloc(8);
  char *o_output = (char*) malloc(8);
  
  memset(o_message, 0, 9);
  memset(o_output, 0, 9);
  //out.resize(in.size() * 2);
  
  while (i < in.size()) {
    out.resize(out.size() + 8);
    memcpy(o_message, in.data() + i, 8);
    DES_ecb_encrypt((DES_cblock *) o_message, (DES_cblock*) o_output, &m_schedule, mode);
    memcpy(out.data() + i, o_output, 8);
    
    // Next 8 bytes
    i += 8;
    
    // Clear everything
    memset(o_message, 0, 9);
    memset(o_output, 0, 9);
  }
  
  free(o_message);
  free(o_output);
  
  if (mode == DES_ENCRYPT) {
    // Base64 encode the output
    m_output = KCodecs::base64Encode(out).data();
  } else {
    m_output = QCString(out).data();
  }
}

void DESEncryptor::setKey(const QString &key)
{
  // Setup our DES key
  DES_string_to_key(key.ascii(), &m_key);  
  DES_set_key_checked(&m_key, &m_schedule);
}

void DESEncryptor::encrypt(const QString &string)
{
  DESExec(string, DES_ENCRYPT);
}

void DESEncryptor::decrypt(const QString &string)
{
  DESExec(string, DES_DECRYPT);
}

QString DESEncryptor::output()
{
  return m_output;
}

}
