
#  _   _______                 _ _ _   _       _   _  __ _
# | | / /  __ \               (_) | \ | |     | | (_)/ _(_)
# | |/ /| |  \/_ __ ___   __ _ _| |  \| | ___ | |_ _| |_ _  ___ _ __
# |    \| | __| '_ ` _ \ / _` | | | . ` |/ _ \| __| |  _| |/ _ \ '__|
# | |\  \ |_\ \ | | | | | (_| | | | |\  | (_) | |_| | | | |  __/ |
# \_| \_/\____/_| |_| |_|\__,_|_|_\_| \_/\___/ \__|_|_| |_|\___|_|

############################################################################
#    Copyright (C) 2007 by Marcel Hasler                                   #
#    mahasler@gmail.com                                                    #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License version 2        #
#    as published by the Free Software Foundation.                         #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

import mysystemtray
from qt import *
from kdeui import KPopupTitle

class TrayIcon(QObject):
	def __init__(self,title,titleIconString,iconString):
		QObject.__init__(self)
		
		# Create and show the system tray icon
		self.itsSystray = mysystemtray.MySystemTray(None,"Systray")
		self.itsSystray.setPixmap(self.itsSystray.loadIcon(iconString))
		self.itsSystray.show()
	
		self.connect(self.itsSystray,PYSIGNAL("mouseButtonPressed()"),self.SendTrayIconClicked)
	
		# Create and insert the app's title and icon into the menu
		self.itsTitle = KPopupTitle()
		self.itsTitle.setTitle(title, QPixmap(titleIconString))
		self.itsSystray.itsMenu.insertItem(self.itsTitle)
		
		
	def SendTrayIconClicked(self):
		self.emit(PYSIGNAL("trayIconClicked()"),())
	
	
	def AddItemToMenu(self,icon,title,slot):
		self.itsSystray.itsMenu.insertItem(QIconSet(QPixmap(icon)),QString(title),slot)
		

	def AddSeparatorToMenu(self):
		self.itsSystray.itsMenu.insertSeparator()
	
	
	def SetIcon(self,iconStr):
		self.itsSystray.setPixmap(self.itsSystray.loadIcon(iconStr))
		self.itsSystray.show()
		
		
	def SetToolTip(self,text):
		QToolTip.remove(self.itsSystray)
		QToolTip.add(self.itsSystray,text)
	
	