/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

#ifndef BACKUP_H
#define BACKUP_H

//KDE
#include <kassistantdialog.h>

//Ui
#include "ui_backup_assistant_intro.h"
#include "ui_backup_assistant_step1.h"
#include "ui_backup_assistant_step2.h"
#include "ui_backup_assistant_summary.h"

#include <kurl.h>

/**
 * @short Backup Assistant.
 *
 * Creates/restores from backup files.
 */
class BackupAssistant : public KAssistantDialog
{
Q_OBJECT
public:
	/**
	* Constructor. Populates the KAssistantDialog, shows the paths and
	* connects the signals to their slots.
	*
	* @param source The source file.
	* @param target The target file.
	* @param parent QWidget parent. Self explanatory.
	*/
	BackupAssistant( KUrl *source, KUrl *target, QWidget *parent = 0 );
private slots:
	/**
	* Before accessing the last page, it collects all data
	* that where entered by the user and creates a summary.
	*/
	void nextClicked();
	/**
	* If the Finish button is pressed, procedes to the backup/restore action.
	*/
	void finishClicked();
private:
	Ui::backup_assistant_intro ui_intro;
	Ui::backup_assistant_step1 ui_step1;
	Ui::backup_assistant_step2 ui_step2;
	Ui::backup_assistant_summary ui_summary;

	KPageWidgetItem *summaryPage;

	KUrl *m_source;
	KUrl *m_target;
};

#endif
