/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


// lib specific
#include "propertydataactionservice.h"


namespace Khalkhi {

PropertyDataActionService::PropertyDataActionService( QObject *Parent, const char *Name,
                                                      const QStringList &Arguments )
 : PropertyService( Parent, Name, Arguments )
{}


bool PropertyDataActionService::supports( QMimeSource */*DataSource*/ ) const
{
    return true;
}

bool PropertyDataActionService::isAvailableFor( QMimeSource *DataSource ) const
{
    return supports( DataSource );
}

bool PropertyDataActionService::supports( QMimeSource *DataSource,
                                                 const KABC::Addressee &/*Person*/, int /*ItemIndex*/ ) const
{
    return supports( DataSource );
}

bool PropertyDataActionService::isAvailableFor( QMimeSource *DataSource,
                                                       const KABC::Addressee &Person, int ItemIndex ) const
{
    return supports( DataSource, Person, ItemIndex );
}

void PropertyDataActionService::registerClient( PropertyDataActionServiceClient */*Client*/, int /*ItemIndex*/ )
{
}

void PropertyDataActionService::unregisterClient( PropertyDataActionServiceClient */*Client*/, int /*ItemIndex*/ )
{
}

PropertyDataActionService::~PropertyDataActionService() {}

}

#include "propertydataactionservice.moc"
