/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/



// qt specific
#include <qstring.h>
// lib specific
#include "propertyadapter.h"
#include "listpropertyactionservice.h"
#include "listpropertydataactionservice.h"
#include "propertymanager.h"


namespace Khalkhi {

PropertyManager::PropertyManager( PropertyAdapter *PA )
: Adapter( PA )
{}

const PropertyAdapter *PropertyManager::propertyAdapter()       const { return Adapter; }
const PropertyStatusServiceList &PropertyManager::statusServices()             const { return StatusServices; }
const PropertyActionServiceList &PropertyManager::actionServices()             const { return ActionServices; }
const PropertyActionServiceList &PropertyManager::mainActionServices()         const { return MainActionServices; }
const PropertyDataActionServiceList &PropertyManager::dataActionServices()     const { return DataActionServices; }
const PropertyDataActionServiceList &PropertyManager::mainDataActionServices() const { return MainDataActionServices; }
QString PropertyManager::id() const { return Adapter->id(); }


void PropertyManager::registerClient( PropertyStatusServiceClient *Client )
{
    //TODO: if( Adapter->isContained(Client->person()) )
    for( PropertyStatusServiceList::Iterator ServiceIt = StatusServices.begin(); ServiceIt != StatusServices.end(); ++ServiceIt )
        (*ServiceIt)->registerClient( Client );

    StatusServiceClients.append( Client );
}


void PropertyManager::unregisterClient( PropertyStatusServiceClient *Client )
{
    for( PropertyStatusServiceList::Iterator ServiceIt = StatusServices.begin(); ServiceIt != StatusServices.end(); ++ServiceIt )
        (*ServiceIt)->unregisterClient( Client );

    StatusServiceClients.remove( Client );
}

void PropertyManager::addStatusService( PropertyStatusService *StatusService )
{
    StatusServices.append( StatusService );
    StatusService->setAdapter( Adapter );

    for( PropertyStatusServiceClientList::Iterator ClientIt = StatusServiceClients.begin();
         ClientIt != StatusServiceClients.end(); ++ClientIt )
        StatusService->registerClient( *ClientIt );

    informStatusServiceClients();
}

void PropertyManager::removeStatusService( const QString &StatusServiceId, bool Delete )
{
    StatusServices.remove( StatusServiceId, Delete );

    informStatusServiceClients();
}

void PropertyManager::informStatusServiceClients()
{
// TODO: 
    // inform clients
//    for( PropertyStatusServiceClientList::Iterator ClientIt = StatusServiceClients.begin();
//         ClientIt != StatusServiceClients.end(); ++ClientIt )
//        (*ClientIt)->onAllServiceChange();
}



void PropertyManager::execute( const KABC::Addressee &Person, int ItemIndex, const QString &ServiceId ) const
{
    PropertyActionService *Service = ActionServices[ServiceId];

    if( Service )
        Service->execute( Person, ItemIndex );
}

void PropertyManager::execute( const KABC::AddresseeList& PersonList, const QString &ServiceId ) const
{
    ListPropertyActionService *Service = ::qt_cast<ListPropertyActionService*>( ActionServices[ServiceId] );

    if( Service )
        Service->execute( PersonList );
}


void PropertyManager::addActionService( PropertyActionService *Service, bool AsMain )
{
    ActionServices.append( Service );
    if( AsMain ) MainActionServices.append( Service );
    Service->setAdapter( Adapter );

    for( PropertyAllActionServiceClientList::Iterator ClientIt = PropertyAllActionServiceClients.begin();
         ClientIt != PropertyAllActionServiceClients.end(); ++ClientIt )
        Service->registerClient( *ClientIt );

    informPropertyAllActionServiceClients();
}


void PropertyManager::removeActionService( const QString &ServiceId, bool Delete )
{
//     bool GlobalChanged = false;

    ActionServices.remove( ServiceId, Delete );

//    if( GlobalChanged )
//        setGlobalService( -1 );
    informPropertyAllActionServiceClients();
}

void PropertyManager::informPropertyAllActionServiceClients()
{
    // inform clients
    for( PropertyAllActionServiceClientList::Iterator ClientIt = PropertyAllActionServiceClients.begin();
         ClientIt != PropertyAllActionServiceClients.end(); ++ClientIt )
        (*ClientIt)->onAllActionServiceChange();
}

void PropertyManager::registerClient( PropertyAllActionServiceClient *Client )
{
    for( PropertyActionServiceList::Iterator ServiceIt = ActionServices.begin(); ServiceIt != ActionServices.end(); ++ServiceIt )
        (*ServiceIt)->registerClient( Client, Client->itemIndex() );

    PropertyAllActionServiceClients.append( Client );
}


void PropertyManager::unregisterClient( PropertyAllActionServiceClient *Client )
{
    for( PropertyActionServiceList::Iterator ServiceIt = ActionServices.begin(); ServiceIt != ActionServices.end(); ++ServiceIt )
        (*ServiceIt)->unregisterClient( Client, Client->itemIndex() );

    PropertyAllActionServiceClients.remove( Client );
}


/*
void PropertyManager::setGlobalService( int ServiceId )
{
    PropertyActionService *NewGlobalService = (ServiceId==-1) ? 0 : ActionServices[ServiceId];

    // no change?
    if( GlobalService == NewGlobalService )
        return;

    // unregister all defaultclients from old default service
    if( GlobalService )
        for( GlobalServiceClientList::Iterator ClientIt = AllPropertiesGlobalActionServiceClients.begin();
             ClientIt != AllPropertiesGlobalActionServiceClients.end(); ++ClientIt )
            GlobalService->unregisterClient( *ClientIt );

    // set new default service
    GlobalService = NewGlobalService;

    // register 
    if( GlobalService )
        for( GlobalServiceClientList::Iterator ClientIt = AllPropertiesGlobalActionServiceClients.begin();
             ClientIt != AllPropertiesGlobalActionServiceClients.end(); ++ClientIt )
            GlobalService->registerClient( *ClientIt );

    // inform clients
    for( GlobalServiceClientList::Iterator ClientIt = AllPropertiesGlobalActionServiceClients.begin();
         ClientIt != AllPropertiesGlobalActionServiceClients.end(); ++ClientIt )
        (*ClientIt)->onGlobalServiceSwitch( propertyId() );
}


int PropertyManager::defaultServiceId() const
{
    return ActionServices.findIndex( GlobalService );
}
*/

void PropertyManager::registerClient( AllPropertiesGlobalActionServiceClient *Client )
{
    for( PropertyActionServiceList::Iterator ServiceIt = MainActionServices.begin(); ServiceIt != MainActionServices.end(); ++ServiceIt )
        (*ServiceIt)->registerClient( Client );

    AllPropertiesGlobalActionServiceClients.append( Client );
}


void PropertyManager::unregisterClient( AllPropertiesGlobalActionServiceClient *Client )
{
    for( PropertyActionServiceList::Iterator ServiceIt = MainActionServices.begin(); ServiceIt != MainActionServices.end(); ++ServiceIt )
        (*ServiceIt)->unregisterClient( Client );

    AllPropertiesGlobalActionServiceClients.remove( Client );
}

void PropertyManager::registerClient( ListAllPropertiesGlobalActionServiceClient *Client )
{
    for( PropertyActionServiceList::Iterator ServiceIt = MainActionServices.begin(); ServiceIt != MainActionServices.end(); ++ServiceIt )
    {
        ListPropertyActionService *ListService = ::qt_cast<ListPropertyActionService*>( *ServiceIt );
        if( ListService )
            ListService->registerClient( Client );
    }

    ListAllPropertiesGlobalActionServiceClients.append( Client );
}


void PropertyManager::unregisterClient( ListAllPropertiesGlobalActionServiceClient *Client )
{
    for( PropertyActionServiceList::Iterator ServiceIt = MainActionServices.begin(); ServiceIt != MainActionServices.end(); ++ServiceIt )
    {
        ListPropertyActionService *ListService = ::qt_cast<ListPropertyActionService*>( *ServiceIt );
        if( ListService )
            ListService->unregisterClient( Client );
    }

    ListAllPropertiesGlobalActionServiceClients.remove( Client );
}


void PropertyManager::addDataActionService( PropertyDataActionService *Service,
                                                   bool AsMain )
{
    DataActionServices.append( Service );
    if( AsMain ) MainDataActionServices.append( Service );
    Service->setAdapter( Adapter );

    for( PropertyAllDataActionServiceClientList::Iterator ClientIt = PropertyAllDataActionServiceClients.begin();
         ClientIt != PropertyAllDataActionServiceClients.end(); ++ClientIt )
        Service->registerClient( *ClientIt );

    informPropertyAllDataActionServiceClients();
}


void PropertyManager::removeDataActionService( const QString &ServiceId, bool Delete )
{
//     bool GlobalChanged = false;
    DataActionServices.remove( ServiceId, Delete );

//     if( GlobalChanged )
//         setGlobalDropService( -1 );

    informPropertyAllDataActionServiceClients();
}


void PropertyManager::informPropertyAllDataActionServiceClients()
{
    // inform clients
    for( PropertyAllDataActionServiceClientList::Iterator ClientIt = PropertyAllDataActionServiceClients.begin();
         ClientIt != PropertyAllDataActionServiceClients.end(); ++ClientIt )
        (*ClientIt)->onAllDataActionServiceChange();
}


void PropertyManager::registerClient( PropertyAllDataActionServiceClient *Client )
{
    for( PropertyDataActionServiceList::Iterator ServiceIt = DataActionServices.begin();
         ServiceIt != DataActionServices.end(); ++ServiceIt )
        (*ServiceIt)->registerClient( Client, Client->itemIndex() );

    PropertyAllDataActionServiceClients.append( Client );
}


void PropertyManager::unregisterClient( PropertyAllDataActionServiceClient *Client )
{
    for( PropertyDataActionServiceList::Iterator ServiceIt = DataActionServices.begin();
         ServiceIt != DataActionServices.end(); ++ServiceIt )
        (*ServiceIt)->unregisterClient( Client, Client->itemIndex() );

    PropertyAllDataActionServiceClients.remove( Client );
}

void PropertyManager::registerClient( AllPropertiesGlobalDataActionServiceClient *Client )
{
    for( PropertyDataActionServiceList::Iterator ServiceIt = MainDataActionServices.begin();
         ServiceIt != MainDataActionServices.end(); ++ServiceIt )
    {
        ListPropertyDataActionService* ListService =
            ::qt_cast<ListPropertyDataActionService*>( *ServiceIt );
        if( ListService )
            ListService->registerClient( Client );
    }

    AllPropertiesGlobalDataActionServiceClients.append( Client );
}


void PropertyManager::unregisterClient( AllPropertiesGlobalDataActionServiceClient *Client )
{
    for( PropertyDataActionServiceList::Iterator ServiceIt = MainDataActionServices.begin();
         ServiceIt != MainDataActionServices.end(); ++ServiceIt )
    {
        ListPropertyDataActionService* ListService =
            ::qt_cast<ListPropertyDataActionService*>( *ServiceIt );
        if( ListService )
            ListService->unregisterClient( Client );
    }

    AllPropertiesGlobalDataActionServiceClients.remove( Client );
}

void PropertyManager::registerClient( ListAllPropertiesGlobalDataActionServiceClient *Client )
{
    for( PropertyDataActionServiceList::Iterator ServiceIt = MainDataActionServices.begin();
         ServiceIt != MainDataActionServices.end(); ++ServiceIt )
    {
        ListPropertyDataActionService *ListService = ::qt_cast<ListPropertyDataActionService*>( *ServiceIt );
        if( ListService )
            ListService->registerClient( Client );
    }

    ListAllPropertiesGlobalDataActionServiceClients.append( Client );
}


void PropertyManager::unregisterClient( ListAllPropertiesGlobalDataActionServiceClient *Client )
{
    for( PropertyDataActionServiceList::Iterator ServiceIt = MainDataActionServices.begin();
         ServiceIt != MainDataActionServices.end(); ++ServiceIt )
    {
        ListPropertyDataActionService *ListService = ::qt_cast<ListPropertyDataActionService*>( *ServiceIt );
        if( ListService )
            ListService->unregisterClient( Client );
    }

    ListAllPropertiesGlobalDataActionServiceClients.remove( Client );
}

/*
void PropertyManager::setGlobalDropService( int DropServiceId )
{
    PropertyDataActionService *NewGlobalDropService = (DropServiceId==-1) ? 0 : DataActionServices[DropServiceId];

    // no change?
    if( GlobalDropService == NewGlobalDropService )
        return;

    // unregister all defaultclients from old default service
    if( GlobalDropService )
        for( GlobalDropServiceClientList::Iterator ClientIt = AllPropertiesMainDataActionServices.begin();
             ClientIt != AllPropertiesMainDataActionServices.end(); ++ClientIt )
            GlobalDropService->unregisterDropClient( *ClientIt );

    // set new default service
    GlobalDropService = NewGlobalDropService;

    // register 
    if( GlobalDropService )
        for( GlobalDropServiceClientList::Iterator ClientIt = AllPropertiesMainDataActionServices.begin();
             ClientIt != AllPropertiesMainDataActionServices.end(); ++ClientIt )
            GlobalDropService->registerDropClient( *ClientIt );

    // inform clients
    for( GlobalDropServiceClientList::Iterator ClientIt = AllPropertiesMainDataActionServices.begin();
         ClientIt != AllPropertiesMainDataActionServices.end(); ++ClientIt )
        (*ClientIt)->onGlobalDropServiceSwitch( propertyId() );
}
*/

void PropertyManager::execute( const KABC::Addressee &Person, int ItemIndex, QMimeSource *DataSource,
                                      const QString &ServiceId ) const
{
    PropertyDataActionService *Service = DataActionServices[ServiceId];

    if( Service )
        Service->execute( Person, ItemIndex, DataSource );
}

void PropertyManager::execute( const KABC::AddresseeList& PersonList, QMimeSource *DataSource,
                                      const QString &ServiceId ) const
{
    ListPropertyDataActionService *Service =
        ::qt_cast<ListPropertyDataActionService*>( DataActionServices[ServiceId] );

    if( Service )
        Service->execute( PersonList, DataSource );
}

void PropertyManager::setActionServiceSorting( const QStringList &ServiceIds )
{
    ActionServices.setOrder( ServiceIds );
    MainActionServices.setOrder( ServiceIds );
}

void PropertyManager::setDataActionServiceSorting( const QStringList &ServiceIds )
{
    DataActionServices.setOrder( ServiceIds );
    MainDataActionServices.setOrder( ServiceIds );
}

void PropertyManager::setStatusServiceSorting( const QStringList &ServiceIds )
{
    StatusServices.setOrder( ServiceIds );
}

enum { ActionServiceId = 0, DataActionServiceId = 1, StatusServiceId = 2 };

void PropertyManager::reloadConfig( int ServiceType, const QString &ServiceId )
{
    Service *Service = 0;
    switch( ServiceType )
    {
        case ActionServiceId: 
            Service = ActionServices[ServiceId];
            break;
        case DataActionServiceId:
            Service = DataActionServices[ServiceId];
            break;
        case StatusServiceId: 
            Service = StatusServices[ServiceId];
    }
    if( Service )
        Service->reloadConfig();
}

PropertyManager::~PropertyManager()
{
    removeActionService( QString::null, true );
    removeDataActionService( QString::null, true );
    removeStatusService( QString::null, true );
}

}
