/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef KHALKHI_PROPERTYSTATUSSERVICE_H
#define KHALKHI_PROPERTYSTATUSSERVICE_H


// lib specific
#include "status.h"
#include "propertyservice.h"

namespace KABC { class Addressee; }


namespace Khalkhi {

class PropertyStatusServiceClient;


// TODO: add possibility to determine if/how dynamic service can be invoked on the type
// perhaps by adding return bool to fillMenu
// better show unavailability instead of ignoring? Or both, chosen by service?
class KDE_EXPORT PropertyStatusService : public PropertyService
{
    Q_OBJECT
public:
    PropertyStatusService( QObject* Parent, const char* Name, const QStringList& Arguments );
    virtual ~PropertyStatusService();

public: // interface
    virtual Status status( const KABC::Addressee &Person, int ItemIndex, int Flags ) const = 0;

    /** @returns if the service is possible for the item; defaults to return true */
    virtual bool supports( const KABC::Addressee &Person, int ItemIndex ) const;

    /** if ItemIndex = -1 register all items */
    virtual void registerClient( PropertyStatusServiceClient *Client, int ItemIndex = -1 );
    virtual void unregisterClient( PropertyStatusServiceClient *Client, int ItemIndex = -1 );
};

inline PropertyStatusService::PropertyStatusService( QObject* Parent, const char* Name,
                                                     const QStringList& Arguments )
 : PropertyService( Parent, Name, Arguments ) {}
inline PropertyStatusService::~PropertyStatusService() {}

}

#endif
