/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


// qt specific
#include <qpopupmenu.h>
// khalkhi core
#include <services.h>
#include <propertyadapter.h>
// lib specific
#include "allpropertiesglobaldataactionservicemenufiller.h"


namespace Khalkhi {


const KABC::Addressee &AllPropertiesGlobalDataActionServiceMenuFiller::person() const { return Person; }
QMimeSource *AllPropertiesGlobalDataActionServiceMenuFiller::dataSource() const        { return DataSource; }

void AllPropertiesGlobalDataActionServiceMenuFiller::onGlobalDataActionServiceSwitch( const QString &/*PropertyId*/ ) { /*TODO: what to do?*/}
void AllPropertiesGlobalDataActionServiceMenuFiller::onPropertyManagerChange() { /*TODO: what to do?*/}

void AllPropertiesGlobalDataActionServiceMenuFiller::onDataActionServiceStateChange(
    const PropertyDataActionService &Service, int /*Change*/, int ItemIndex )
{
    const QString &ServiceId = Service.id();

    int MaxItemIndex;
    if( ItemIndex == -1 )
    {
        ItemIndex = 0;
        MaxItemIndex = Service.adapter()->numberOfItems( Person );
    }
    else
        MaxItemIndex = ItemIndex+1;

    for( ; ItemIndex<MaxItemIndex; ++ItemIndex )
    {
        // find menuid of action
        int Flags;
        int MenuId = IdActionMap.menuId( Service.adapter()->id(), ItemIndex, ServiceId, &Flags );

        if( MenuId != -1 )
        {
            ServiceAction Action = Service.action( Person, ItemIndex, DataSource, Flags );

            QString Entry = Action.data( DisplayTextRole ).asString();
            QIconSet IconSet = Action.data( DisplayIconRole ).asIconSet();
            bool Enabled = Action.data( EnabledRole ).asBool();

            Menu->changeItem( MenuId, IconSet, Entry );
            Menu->setItemEnabled( MenuId, Enabled );
        }
    }
}


int AllPropertiesGlobalDataActionServiceMenuFiller::fillMenu( QPopupMenu *M, int BaseMenuId )
{
    const PropertyManagerList &Managers = Services::self()->propertyManagers();

    Menu = M;
    connect( Menu, SIGNAL(aboutToHide()), SLOT(onMenuDestruction()) );
    Services::self()->registerClient( this );

    int MenuId = BaseMenuId;
    IdActionMap.prepare( Managers.size() );
    PropertyManagerList::ConstIterator ManagerIt = Managers.begin();
    for( ; ManagerIt != Managers.end(); ++ManagerIt )
    {
        const PropertyManager &Manager = **ManagerIt;

        const PropertyDataActionServiceList &Services = Manager.mainDataActionServices();
        if( Services.size() == 0 )
            continue;

        const PropertyAdapter *Adapter = Manager.propertyAdapter();
        const int ItemsSize = Adapter->numberOfItems( Person );
        if( ItemsSize == 0 )
            continue;

        IdActionMap.addProperty( Adapter->id(), Services.size() );

        for( PropertyDataActionServiceList::ConstIterator ServiceIt = Services.begin(); ServiceIt != Services.end(); ++ServiceIt )
        {
            const PropertyDataActionService &Service = **ServiceIt;

            if( !Service.isAvailableFor(DataSource) )
                ;// TODO: 
            else
            {
                // find if properties have to be referenced
                int SupportedItems = 0;
                for( int ItemIndex = 0; ItemIndex<ItemsSize; ++ItemIndex )
                    if( Service.supports(DataSource,Person,ItemIndex) )
                        SupportedItems++;
                if( SupportedItems == 0 )
                    continue;

                int Flags = PropertyService::Always;
                if( SupportedItems > 1 )
                    Flags |= PropertyService::ReferItem;

                IdActionMap.addService( Service.id(), ItemsSize );

                // insert service action entries
                for( int ItemIndex = 0; ItemIndex<ItemsSize; ++ItemIndex )
                {
                    if( Service.supports(DataSource,Person,ItemIndex) )
                    {
                        IdActionMap.addItem( ItemIndex, MenuId, Flags );

                        ServiceAction Action = Service.action( Person, ItemIndex, DataSource, Flags );

                        QString Entry = Action.data( DisplayTextRole ).asString();
                        QIconSet IconSet = Action.data( DisplayIconRole ).asIconSet();
                        bool Enabled = Action.data( EnabledRole ).asBool();

                        Menu->insertItem( IconSet, Entry, this, SLOT(onMenuSelection(int)), 0, MenuId );
                        if( !Enabled )
                            Menu->setItemEnabled( MenuId, false );
                        ++MenuId;
                    }
                }
            }
        }
    }

    return MenuId - BaseMenuId;
}


void AllPropertiesGlobalDataActionServiceMenuFiller::onMenuSelection( int Id )
{
    QString PropertyId;
    int ItemIndex;
    QString ServiceId;

    if( IdActionMap.remap(&PropertyId,&ItemIndex,&ServiceId, Id) )
        Services::self()->execute( Person, PropertyId, ItemIndex, ServiceId, DataSource );
}


void AllPropertiesGlobalDataActionServiceMenuFiller::onMenuDestruction()
{
    Services::self()->unregisterClient( this );
}

AllPropertiesGlobalDataActionServiceMenuFiller::~AllPropertiesGlobalDataActionServiceMenuFiller() {}

}

#include "allpropertiesglobaldataactionservicemenufiller.moc"
