/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


// qt specific
#include <qpopupmenu.h>
// khalkhi core 
#include <services.h>
#include <propertyadapter.h>
// lib specific
#include "propertyallactionservicemenufiller.h"


namespace Khalkhi {

PropertyAllActionServiceMenuFiller::PropertyAllActionServiceMenuFiller()
: Menu( 0 ) {}


void PropertyAllActionServiceMenuFiller::set( const KABC::Addressee& C, const QString &P, int I )
{
    Person = C; PropertyId = P; ItemIndex = I;
}

int PropertyAllActionServiceMenuFiller::itemIndex()     const              { return ItemIndex; }
QString PropertyAllActionServiceMenuFiller::propertyId() const             { return PropertyId; }
const KABC::Addressee& PropertyAllActionServiceMenuFiller::person() const { return Person; }


void PropertyAllActionServiceMenuFiller::onAllActionServiceChange()
{ /*TODO: what to do? update menu*/}

void PropertyAllActionServiceMenuFiller::onActionServiceStateChange( const PropertyActionService &Service,
                                                                     int /*Change*/, int /*ItemIndex*/ )
{
    const QString &ServiceId = Service.id();

    // find menuid of action
    int MenuId = -1;
    int i = BaseMenuId;
    for ( QStringList::Iterator it = MenuServiceIds.begin(); it != MenuServiceIds.end(); ++it,++i )
        if( *it == ServiceId )
        {
            MenuId = i;
            break;
        }

    if( MenuId != -1 )
    {
        ServiceAction Action = Service.action( Person, ItemIndex, 0 );

        QString Entry = Action.data( DisplayTextRole ).asString();
        QIconSet IconSet = Action.data( DisplayIconRole ).asIconSet();
        bool Enabled = Action.data( EnabledRole ).asBool();

        Menu->changeItem( MenuId, IconSet, Entry );
        Menu->setItemEnabled( MenuId, Enabled );
    }
}


int PropertyAllActionServiceMenuFiller::fillMenu( QPopupMenu *M, int BMI )
{
    BaseMenuId = BMI;
    Menu = M;
    MenuServiceIds.clear();

    connect( Menu, SIGNAL(destroyed()), SLOT(onMenuDestruction()) );
    Services::self()->registerClient( this );

    PropertyManager *Manager = Services::self()->propertyManagers()[PropertyId];
    if( !Manager )
        return 0;

    const PropertyActionServiceList &Services = Manager->actionServices();

    int MenuId = BaseMenuId;
    for( PropertyActionServiceList::ConstIterator ServiceIt = Services.begin(); ServiceIt != Services.end(); ++ServiceIt )
    {
        const PropertyActionService *Service = *ServiceIt;

        if( !Service->isAvailable() )
            ;// TODO: 
        else if( Service->supports(Person,ItemIndex) )
        {
            ServiceAction Action = Service->action( Person, ItemIndex, 0 );

            QString Entry = Action.data( DisplayTextRole ).asString();
            QIconSet IconSet = Action.data( DisplayIconRole ).asIconSet();
            bool Enabled = Action.data( EnabledRole ).asBool();

            Menu->insertItem( IconSet, Entry, this, SLOT(onMenuSelection(int)), 0, MenuId );
            if( !Enabled )
                Menu->setItemEnabled( MenuId, false );
            MenuServiceIds.append( Service->id() );
            ++MenuId;
        }
    }

    return MenuId - BaseMenuId;
}

void PropertyAllActionServiceMenuFiller::onMenuSelection( int MenuId )
{
    Services::self()->execute( Person, PropertyId, ItemIndex, MenuServiceIds[MenuId-BaseMenuId] );
}

void PropertyAllActionServiceMenuFiller::onMenuDestruction()
{
    Menu = 0;
    Services::self()->unregisterClient( this );
}

PropertyAllActionServiceMenuFiller::~PropertyAllActionServiceMenuFiller() {}

}

#include "propertyallactionservicemenufiller.moc"
