/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef KHALKHI_CARDVIEW_H
#define KHALKHI_CARDVIEW_H


// qt specific
#include <qtextbrowser.h>
// kde specific
#include <kabc/addressee.h>


namespace Khalkhi {

class GlobalServiceClientCardProxy;
class PropertyAllActionServiceMenuFiller;
class PropertyAllDataActionServiceMenuFiller;
class AllPropertiesGlobalActionServiceMenuFiller;
class AllPropertiesGlobalDataActionServiceMenuFiller;
class StatusClientCardProxy;

using namespace KABC;

/**
* View of a person with his properties and its' default services.
* Offers also access to all services for each property
*/
class KDE_EXPORT CardView : public QTextBrowser
{
  Q_OBJECT

public:
    explicit CardView( QWidget *Parent = 0, const char *Name = 0 );
    virtual ~CardView();

public:
    const KABC::Addressee &person() const;

public slots:
    virtual void updateView();
    void setPerson( const Addressee& C );

// signals:
//     void actionHighlighted( const QString &Text );

protected: // QTextBrowser API
    virtual void setSource( const QString &Name );

protected: // QTextEdit API
    virtual QPopupMenu *createPopupMenu( const QPoint& Pos );

protected: // QScrollView API
    virtual void contentsDragEnterEvent( QDragEnterEvent *Event );
    virtual void contentsDragLeaveEvent( QDragLeaveEvent *Event );
    virtual void contentsDragMoveEvent( QDragMoveEvent *Event );
    virtual void contentsDropEvent( QDropEvent *Event );

protected:
    QString createCard();

// protected slots:
//     void onHighLighted( const QString &Link );

protected:
    KABC::Addressee Person;

    GlobalServiceClientCardProxy *GlobalServicesProxy;

    PropertyAllActionServiceMenuFiller *PropertyServices;
    AllPropertiesGlobalActionServiceMenuFiller *Services;

    PropertyAllDataActionServiceMenuFiller *PropertyDropServices;
    AllPropertiesGlobalDataActionServiceMenuFiller *DropServices;

    StatusClientCardProxy *StatusProxy;
};


inline const KABC::Addressee &CardView::person() const { return Person; }

}
#endif
