/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/



#ifndef TYPE_PROPERTYADAPTERIF_H
#define TYPE_PROPERTYADAPTERIF_H


// qt specific
#include <qstring.h>


class PropertType {
public:
    PropertType( const QString &D ) : Data( D ) {}
    const QString &data() const { return Data; }
protected:
    QString Data;
};

class TYPE_PropertyAdapterIf
{
protected:
    TYPE_PropertyAdapterIf();
public:
    virtual ~TYPE_PropertyAdapterIf();

public: // our API
    virtual PropertType property( const KABC::Addressee &Person, int ItemIndex ) const = 0;
};


inline TYPE_PropertyAdapterIf::TYPE_PropertyAdapterIf() {}
inline TYPE_PropertyAdapterIf::~TYPE_PropertyAdapterIf() {}

#endif
