/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kiaxregistrationindicator.h"

KiaxRegistrationIndicator::KiaxRegistrationIndicator(QWidget *parent, const char *name, KiaxAccount* account)
 : QLabel(parent, name, 0)
{
	connect(account , SIGNAL( signalRegistrationInactive(KiaxAccount*) ), this, SLOT( registrationInactive() ) );
	connect(account , SIGNAL( signalRegistrationConnecting(KiaxAccount*) ), this, SLOT( registrationConnecting() ) );
	connect(account , SIGNAL( signalRegistrationAccepted(KiaxAccount*) ), this, SLOT( registrationAccepted() ) );
	connect(account , SIGNAL( signalRegistrationRejected(KiaxAccount*) ), this, SLOT( registrationRejected() ) );
	connect(account , SIGNAL( signalRegistrationTimeout(KiaxAccount*) ), this, SLOT( registrationTimeout() ) );
	setAccount(account);
	
	KiaxMainWindow* mainWin = (KiaxMainWindow*) parent->topLevelWidget();

	iconsPath = mainWin->getIconsPath();
        QImage imInactive ( iconsPath + "account-small.png" );
        QImage imConnected ( iconsPath + "account-connected.png" );
        QImage imRejected ( iconsPath + "account-rejected.png" );
        QImage imTimeout ( iconsPath + "account-timeout.png" );
        QImage imConnecting ( iconsPath + "account-connecting.png" );

	int sizeX = 10;
	int sizeY = 10;
	imInactive = imInactive.smoothScale(sizeX,sizeY);
	imConnected = imConnected.smoothScale(sizeX,sizeY);
	imRejected = imRejected.smoothScale(sizeX,sizeY);
	imTimeout =imTimeout.smoothScale(sizeX,sizeY);
	imConnecting = imConnecting.smoothScale(sizeX,sizeY);
	
	QPixmap* pmInactive = new QPixmap(imInactive);
	QPixmap* pmConnecting = new QPixmap(imConnecting);
	QPixmap* pmConnected = new QPixmap(imConnected);
	QPixmap* pmRejected = new QPixmap(imRejected);
	QPixmap* pmTimeout = new QPixmap(imTimeout);

	setIconInactive(pmInactive);
	setIconAccepted(pmConnected);
	setIconRejected(pmRejected);
	setIconConnecting(pmConnecting);
	setIconTimeout(pmTimeout);

	popupMenu = new QPopupMenu(this);
  	popupMenu->insertItem(tr("Unregister from") + " " + account->accAlias, this, SLOT(unregisterAccount())) ;
  	popupMenu->insertSeparator();
  	popupMenu->insertItem(tr("Register with") + " " + account->accAlias, this, SLOT(registerAccount())) ;

	if (account->state == ACCOUNT_ACCEPTED) {
		registrationAccepted();
	} else {
		registrationInactive();
        }

	resize(20,20);

}

KiaxRegistrationIndicator::~KiaxRegistrationIndicator()
{
	delete popupMenu;
}

void KiaxRegistrationIndicator::registerAccount() {
	emit signalRegisterAccountAction(account);
}

void KiaxRegistrationIndicator::unregisterAccount() {
	emit signalUnregisterAccountAction(account);
}

void KiaxRegistrationIndicator::registrationTimeout() {
   setPixmap(*iconTimeout);
}

void KiaxRegistrationIndicator::registrationConnecting() {
   setPixmap(*iconConnecting);
}

void KiaxRegistrationIndicator::registrationAccepted() {
   setPixmap(*iconAccepted);
}

void KiaxRegistrationIndicator::registrationRejected() {
   setPixmap(*iconRejected);
}

void KiaxRegistrationIndicator::registrationInactive() {
   setPixmap(*iconInactive);
}

void KiaxRegistrationIndicator::mousePressEvent ( QMouseEvent * e ) {
    KiaxAccount* acc = getAccount();
    popupMenu->popup(e->globalPos(),0);
}

void KiaxRegistrationIndicator::setAccount(KiaxAccount* account) {
   this->account = account;
}

QSize KiaxRegistrationIndicator::sizeHint () const {
	return QSize(10,10);
}

QSize KiaxRegistrationIndicator::minimumSizeHint () const {
	return QSize(10,10);
}

KiaxAccount* KiaxRegistrationIndicator::getAccount()
{
    return this->account;
}

void KiaxRegistrationIndicator::setIconConnecting(QPixmap* icon) {
	iconConnecting = icon;
}

void KiaxRegistrationIndicator::setIconRejected(QPixmap* icon) {
	iconRejected = icon;
}

void KiaxRegistrationIndicator::setIconAccepted(QPixmap* icon) {
	iconAccepted = icon;
}

void KiaxRegistrationIndicator::setIconInactive(QPixmap* icon) {
	iconInactive = icon;
}

void KiaxRegistrationIndicator::setIconTimeout(QPixmap* icon) {
	iconTimeout = icon;
}
