/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SOURCELISTITEM_H
#define SOURCELISTITEM_H

#include <qlistview.h>
#include <qobject.h>
#include <sources/source.h>

/**
 * SourceListItem 
 * @author Ken Werner
 */
class SourceListItem : public QObject, public QCheckListItem {
	Q_OBJECT //macro which activates signals and slots (moc)
public:
	/**
	 * Creates a new Source
	 */
	SourceListItem(Source* inSource, QCheckListItem* inParent, Type tt = RadioButtonController );
 	SourceListItem(Source* inSource, QCheckListItem* inParent, QListViewItem* after, Type tt = RadioButtonController );
 	SourceListItem(Source* inSource, QListViewItem* inParent, Type tt = RadioButtonController );
 	SourceListItem(Source* inSource, QListViewItem* v, QListViewItem* after, Type tt = RadioButtonController );
 	SourceListItem(Source* inSource, QListView* inParent, Type tt = RadioButtonController );
 	SourceListItem(Source* inSource, QListView* inParent, QListViewItem* after, Type tt = RadioButtonController );
 	SourceListItem(Source* inSource, QListViewItem* inParent, const QPixmap& p );
 	SourceListItem(Source* inSource, QListView* inParent, const QPixmap& p );

	virtual ~SourceListItem();

	/**
	 * initializes the item (connects signals and slots)
	 */
	void initItem();

	/**
	 * Returns a pointer to the Source
	 */
	Source* getSource();

public slots:
	/**
	 * Sets whether this source is enabled or not
	 */
	void setEnabled(bool inEnabled);

	/**
	 * Sets the Name of this source
	 */
	void setName(const QString& inName);

    /**
     * updates the text of the item
     */
    void updateText();

signals:
	/**
	 * This signal is emitted whenever the "on" flag (setOn) of this Item has changed
	 */
	void toggled(bool inToggled);
	
protected:
	/**
	 * This virtual function is called when the item changes its state
     */
	virtual void stateChange(bool inEnabled);

	/**
	 * Pointer to the Source
	 */
	Source* mSource;
};
#endif //SOURCELISTITEM_H
