/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "ibmhdaps.h"
#include <qtextstream.h> 
#include <qdir.h>
#include <klocale.h>

IBMHDAPSSrc::IBMHDAPSSrc(QWidget* inParent, const QFile& inSourceFile):
		LabelSource(inParent),
		mSourceFile(inSourceFile.name()),
		mTrigger(this){
	mID = "HDAPS" + mSourceFile.name().section( '/', -1, -1, QString::SectionSkipEmpty ).remove("temp");
	mName = mID;
	mDescription = i18n("This thermal source is provided by the IBM HDAPS driver.");
}

IBMHDAPSSrc::~IBMHDAPSSrc(){
}

std::list<Source*>IBMHDAPSSrc::createInstances(QWidget* inParent){
	std::list<Source*> list;
	QDir hdapsDir( "/sys/bus/platform/drivers/hdaps/hdaps" );
	if ( hdapsDir.exists() ){
		hdapsDir.setFilter( QDir::Files | QDir::NoSymLinks );
		hdapsDir.setSorting( QDir::Name);
		for ( unsigned int i = 0; i < hdapsDir.count(); i++ ){
			if(hdapsDir[i].startsWith("temp")){
				QFile hdapsFile(hdapsDir.canonicalPath() + "/" + hdapsDir[i]);
				list.push_back(new IBMHDAPSSrc(inParent, hdapsFile));
			}
		}
	}
	return list;
}

QString IBMHDAPSSrc::fetchValue(){
	QString s = "n/a";
	if(mSourceFile.open(IO_ReadOnly)){
		QTextStream textStream( &mSourceFile );
		s = textStream.readLine().stripWhiteSpace();
		mSourceFile.close();
		s = formatTemperature(s);
	}
	return s;
}
