#include <gtk/gtk.h>
#include <glade/glade.h>
#include <string.h>
#include <time.h>

#include "kpnewcommentdialog.h"
#include "kpcalendarview.h"
#include "kpmainwindow.h"
#include "kpguiutils.h"
#include "kpdateentry.h"

#include "../kpcalendarentry.h"
#include "../kptraininglog.h"
#include "../kipina-i18n.h"
#include "../kpsettings.h"
#include "../kputil.h"
#include "../kpworkout.h"

static void kp_new_comment_dialog_class_init  (KPNewCommentDialogClass *klass);
static void kp_new_comment_dialog_init        (KPNewCommentDialog *dialog);
static void kp_new_comment_dialog_finalize    (GObject *object);
static void date_selected                     (KPDateEntry *entry, 
                                               KPDate *date, 
                                               KPNewCommentDialog *dialog);
static void time_selected                     (KPDateEntry *entry, 
                                               KPTime *time, 
                                               KPNewCommentDialog *dialog);
static void text_changed                      (GtkTextBuffer *buffer,
                                               KPNewCommentDialog *dialog);
static void title_changed                     (GtkEditable *editable,
                                               KPNewCommentDialog *dialog);
static void dialog_response_cb                (GtkDialog *gtkdialog, 
                                               gint resp_id, 
                                               KPNewCommentDialog *dialog);


typedef struct KPNewCommentDialogPrivateData_
{
  KPComment *comment;
  
  GtkTextBuffer *buffer;
  GtkWidget *title_entry;
  GtkWidget *textview;
  GtkWidget *date_entry;
} KPNewCommentDialogPrivateData;

#define KP_NEW_COMMENT_DIALOG_PRIVATE_DATA(widget) (((KPNewCommentDialogPrivateData*) \
        (KP_NEW_COMMENT_DIALOG (widget)->private_data)))

static GObjectClass *parent_class = NULL;

GType
kp_new_comment_dialog_get_type (void)
{
  static GType kp_new_comment_dialog_type = 0;

  if (kp_new_comment_dialog_type == 0) {
    static const GTypeInfo our_info = {
      sizeof (KPNewCommentDialogClass),
      NULL,
      NULL,
      (GClassInitFunc) kp_new_comment_dialog_class_init,
      NULL,
      NULL,
      sizeof (KPNewCommentDialog),
      0,
      (GInstanceInitFunc) kp_new_comment_dialog_init,
      NULL,
    };

    kp_new_comment_dialog_type = g_type_register_static (KP_TYPE_ADD_EDIT_DIALOG,
                                                         "KPNewCommentDialog",
                                                         &our_info, 0);
  }

  return kp_new_comment_dialog_type;
}

static void
kp_new_comment_dialog_class_init (KPNewCommentDialogClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  parent_class = g_type_class_peek_parent (klass);
  
  object_class->finalize = kp_new_comment_dialog_finalize;
}



static void
kp_new_comment_dialog_init (KPNewCommentDialog *dialog)
{
  KPNewCommentDialogPrivateData *p_data;
  GladeXML *xml;

  xml = kp_gui_load ("new_comment", "new_comment");

  dialog->private_data = g_new0 (KPNewCommentDialogPrivateData, 1);
  p_data = KP_NEW_COMMENT_DIALOG_PRIVATE_DATA (dialog);
  
  gtk_window_set_title (GTK_WINDOW (dialog), _("Comment Editor"));

  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox),
                     KP_W (xml, "new_comment"));

  /* Put widgets to private data */
  p_data->title_entry = KP_W (xml, "title_entry");
  p_data->textview = KP_W (xml, "textview");  
  p_data->date_entry = kp_date_entry_new ();
 
  gtk_widget_set_size_request (GTK_WIDGET (p_data->textview), 200, 100);
  gtk_widget_show (p_data->date_entry);

  p_data->buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (p_data->textview));
  g_signal_connect (G_OBJECT (p_data->buffer), "changed",
                    G_CALLBACK (text_changed), dialog);
  g_signal_connect (G_OBJECT (p_data->date_entry), "date-selected",
                    G_CALLBACK (date_selected), dialog);
  g_signal_connect (G_OBJECT (p_data->date_entry), "time-selected",
                    G_CALLBACK (time_selected), dialog);
  g_signal_connect (G_OBJECT (p_data->title_entry), "changed",
                    G_CALLBACK (title_changed), dialog);
  g_signal_connect (G_OBJECT (dialog), "response",
                    G_CALLBACK (dialog_response_cb), dialog);
  g_signal_connect_swapped (G_OBJECT (dialog), "response",
                            G_CALLBACK (gtk_widget_destroy), dialog);
 
  gtk_box_pack_start (GTK_BOX (KP_W (xml, "datebox")), p_data->date_entry, 
                      FALSE, TRUE, 0);
  
  g_object_unref (G_OBJECT (xml));
}


static void
dialog_response_cb (GtkDialog *gtkdialog, gint resp_id, 
                    KPNewCommentDialog *dialog)
{
  KPNewCommentDialogPrivateData *p_data;
  KPTrainingLog *log;
 
  /* </temp> */
  if (resp_id != GTK_RESPONSE_OK)
    return;

  g_return_if_fail (G_IS_OBJECT (dialog));
  
  p_data = KP_NEW_COMMENT_DIALOG_PRIVATE_DATA (dialog);
  log = kp_main_window_get_log ();
  g_return_if_fail (KP_IS_TRAINING_LOG (log));

  kp_training_log_add (log, KP_CALENDAR_ENTRY (p_data->comment));
}



static void
kp_new_comment_dialog_finalize (GObject *object)
{
  KPNewCommentDialog *dialog;

  g_return_if_fail (object != NULL);
  g_return_if_fail (KP_IS_NEW_COMMENT_DIALOG (object));

  dialog = KP_NEW_COMMENT_DIALOG (object);

  g_return_if_fail (dialog->private_data != NULL);
  g_free (dialog->private_data);
  
  G_OBJECT_CLASS (parent_class)->finalize (object);
}

  
static void
fill_data (KPNewCommentDialog *dialog)
{
  KPNewCommentDialogPrivateData *p_data;
  
  p_data = KP_NEW_COMMENT_DIALOG_PRIVATE_DATA (dialog);
  
  gtk_entry_set_text (GTK_ENTRY (p_data->title_entry), 
                      kp_comment_get_title (p_data->comment));
  gtk_text_buffer_set_text (p_data->buffer, 
                            kp_comment_get_text (p_data->comment), -1);
}


GtkWidget *
kp_new_comment_dialog_new (KPDate *date, KPComment *comment)
{
  KPNewCommentDialogPrivateData *p_data;
  KPNewCommentDialog *dialog;

  dialog = g_object_new (KP_TYPE_NEW_COMMENT_DIALOG, 
            "mode", (comment) ? KP_ADD_EDIT_MODE_EDIT : KP_ADD_EDIT_MODE_ADD,
             NULL);

  g_assert (KP_IS_ADD_EDIT_DIALOG (dialog));
  
  p_data = KP_NEW_COMMENT_DIALOG_PRIVATE_DATA (dialog);
 
  if (comment) {
    p_data->comment = comment;
    fill_data (dialog);
  } else
    p_data->comment = kp_comment_new ("", "");
   
  kp_date_entry_set_date (KP_DATE_ENTRY (p_data->date_entry), date);
  kp_calendar_time_set_dmy (KP_CALENDAR_ENTRY (p_data->comment)->datetime,
                            date->d, date->m, date->y);
  
  return GTK_WIDGET (dialog);
}


static void
date_selected (KPDateEntry *entry, KPDate *date, KPNewCommentDialog *dialog)
{
  KPNewCommentDialogPrivateData *p_data;
  p_data = KP_NEW_COMMENT_DIALOG_PRIVATE_DATA (dialog);
  
  if (KP_IS_CALENDAR_ENTRY (p_data->comment))
    kp_calendar_time_set_dmy (KP_CALENDAR_ENTRY (p_data->comment)->datetime, 
                              date->d, date->m, date->y);
}


static void 
time_selected (KPDateEntry *entry, KPTime *time, KPNewCommentDialog *dialog)
{
  KPNewCommentDialogPrivateData *p_data;
  p_data = KP_NEW_COMMENT_DIALOG_PRIVATE_DATA (dialog);
 
  if (KP_IS_CALENDAR_ENTRY (p_data->comment)) 
    kp_calendar_time_set_hmst (KP_CALENDAR_ENTRY (p_data->comment)->datetime, 
                               time->h, time->m, time->s, 0);
}


static void 
text_changed (GtkTextBuffer *buffer, KPNewCommentDialog *dialog)
{
  KPNewCommentDialogPrivateData *p_data;
  GtkTextIter start, end;
  gchar *text;
  
  p_data = KP_NEW_COMMENT_DIALOG_PRIVATE_DATA (dialog);
  
  gtk_text_buffer_get_start_iter (buffer, &start);
  gtk_text_buffer_get_end_iter (buffer, &end);
  text = gtk_text_buffer_get_text (buffer, &start, &end, TRUE);

  kp_comment_set_text (p_data->comment, text);
}


static void 
title_changed (GtkEditable *editable, KPNewCommentDialog *dialog)
{
  KPNewCommentDialogPrivateData *p_data;
  const gchar *text;
  
  p_data = KP_NEW_COMMENT_DIALOG_PRIVATE_DATA (dialog);

  text = gtk_entry_get_text (GTK_ENTRY (p_data->title_entry));
  kp_comment_set_title (p_data->comment, text);
}
