#ifndef KP_SIDEBAR_H_
#define KP_SIDEBAR_H_

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "../kptraininglog.h"

#include "kpviewmodel.h"

#define KP_TYPE_SIDEBAR (kp_sidebar_get_type())
#define KP_SIDEBAR(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_SIDEBAR, KPSidebar))
#define KP_SIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_SIDEBAR, KPSidebarClass))
#define KP_IS_SIDEBAR(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_SIDEBAR))
#define KP_IS_SIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_SIDEBAR))
#define KP_SIDEBAR_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_SIDEBAR, KPSidebarClass))

typedef struct KPSidebar_
{
  GtkVBox         parent;

  gpointer        private_data;
} KPSidebar;

typedef struct KPSidebarClass_
{
  GtkVBoxClass    parent;

} KPSidebarClass;

GType                 kp_sidebar_get_type           (void);

GtkWidget            *kp_sidebar_new                (void);
void                  kp_sidebar_add_widget         (KPSidebar *bar,
                                                     GtkWidget *widget,
                                                     const gchar *title,
                                                     gboolean use_expander);

#endif
