#ifndef KP_SPLITS_VIEW_H_
#define KP_SPLITS_VIEW_H_

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include "../kpcalendarentry.h"
#include "../kpresults.h"
#include "../kpsplit.h"

#define KP_TYPE_SPLITS_VIEW (kp_splits_view_get_type())
#define KP_SPLITS_VIEW(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_SPLITS_VIEW, KPSplitsView))
#define KP_SPLITS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_SPLITS_VIEW, KPSplitsViewClass))
#define KP_IS_SPLITS_VIEW(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_SPLITS_VIEW))
#define KP_IS_SPLITS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_SPLITS_VIEW))
#define KP_SPLITS_VIEW_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_SPLITS_VIEW, KPSplitsViewClass))

typedef struct KPSplitsView_
{
  GtkTreeView     parent;

  gpointer        private_data;
} KPSplitsView;

typedef struct KPSplitsViewClass_
{
  GtkTreeViewClass  parent;
  void            (*split_selected)(KPSplitsView *view, KPSplit *split);
} KPSplitsViewClass;

GType           kp_splits_view_get_type       (void);
GtkWidget      *kp_splits_view_new            (GSList *splits);
void            kp_splits_view_set_splits     (KPSplitsView *view,
                                               GSList *splits);
GSList         *kp_splits_view_get_splits     (KPSplitsView *view);
guint           kp_splits_view_get_selected_split_n 
                                              (KPSplitsView *view);

#endif
