#include <gtk/gtk.h>
#include <glib-object.h>

#include "../kptraininglog.h"
#include "../kipina-i18n.h"

#include "kpviewmodel.h"

static void         kp_view_model_base_init         (GObjectClass *klass);

enum {
  DATE_SET,
  VIEW_SET,
  LOG_SET,
  LOG_UNSET,
  LAST_SIGNAL
};

static guint kp_view_model_signals[LAST_SIGNAL] = { 0 };

GType
kp_view_model_get_type ()
{
  static GType kp_view_model_type = 0;

  if (!kp_view_model_type) {
    static const GTypeInfo kp_view_model_info = {
      sizeof (KPViewModelIface),
      (GBaseInitFunc) kp_view_model_base_init,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL
    };
    kp_view_model_type = g_type_register_static (G_TYPE_INTERFACE,
                                                "KPViewModel",
                                                &kp_view_model_info,
                                                 0);
    g_type_interface_add_prerequisite (kp_view_model_type, GTK_TYPE_WIDGET);
  }
  return kp_view_model_type;
}

static void
kp_view_model_base_init (GObjectClass *klass)
{
  static gboolean initialized = FALSE;

  if (!initialized) {
    kp_view_model_signals[DATE_SET] = 
      g_signal_new ("date-set",
                    KP_TYPE_VIEW_MODEL,
                    G_SIGNAL_RUN_LAST,
                    G_STRUCT_OFFSET (KPViewModelIface, date_set),
                    NULL, NULL,
                    g_cclosure_marshal_VOID__POINTER,
                    G_TYPE_NONE,
                    1,
                    G_TYPE_POINTER);
    kp_view_model_signals[VIEW_SET] = 
      g_signal_new ("view-set",
                    KP_TYPE_VIEW_MODEL,
                    G_SIGNAL_RUN_LAST,
                    G_STRUCT_OFFSET (KPViewModelIface, view_set),
                    NULL,
                    NULL,
                    g_cclosure_marshal_VOID__UINT,
                    G_TYPE_NONE,
                    1,
                    G_TYPE_UINT);
    kp_view_model_signals[LOG_SET] = 
      g_signal_new ("log-set",
                    KP_TYPE_VIEW_MODEL,
                    G_SIGNAL_RUN_LAST,
                    G_STRUCT_OFFSET (KPViewModelIface, log_set),
                    NULL,
                    NULL,
                    g_cclosure_marshal_VOID__POINTER,
                    G_TYPE_NONE,
                    1,
                    G_TYPE_POINTER);
    kp_view_model_signals[LOG_UNSET] = 
      g_signal_new ("log-unset",
                    KP_TYPE_VIEW_MODEL,
                    G_SIGNAL_RUN_LAST,
                    G_STRUCT_OFFSET (KPViewModelIface, log_unset),
                    NULL,
                    NULL,
                    g_cclosure_marshal_VOID__VOID,
                    G_TYPE_NONE,
                    0);

    initialized = TRUE;
  }
}


void
kp_view_model_set_dmy (KPViewModel *model, guint d, guint m, guint y)
{
  KPDate date;

  g_return_if_fail (KP_IS_VIEW_MODEL (model));
  KP_VIEW_MODEL_GET_CLASS (model)->set_dmy (model, d, m, y);

  date.d = d;
  date.m = m;
  date.y = y;
  
  g_signal_emit (model, kp_view_model_signals[DATE_SET], 0, &date);
}

void
kp_view_model_get_dmy (KPViewModel *model, guint *d, guint *m, guint *y)
{
  g_return_if_fail (KP_IS_VIEW_MODEL (model));
  KP_VIEW_MODEL_GET_CLASS (model)->get_dmy (model, d, m, y);
}
 

void
kp_view_model_set_date (KPViewModel *model, KPDate *date)
{
  kp_view_model_set_dmy (model, date->d, date->m, date->y);
}


void
kp_view_model_get_date (KPViewModel *model, KPDate *date)
{
  kp_view_model_get_dmy (model, &date->d, &date->m, &date->y);
}


void
kp_view_model_set_view_type (KPViewModel *model, KPViewModelType type)
{
  KP_VIEW_MODEL_GET_CLASS (model)->set_view_type (model, type);

  g_signal_emit (model, kp_view_model_signals[VIEW_SET], 0, type);
}


KPViewModelType
kp_view_model_get_view_type (KPViewModel *model)
{
  return KP_VIEW_MODEL_GET_CLASS (model)->get_view_type (model);
}

void
kp_view_model_set_log (KPViewModel *model, KPTrainingLog *log)
{
  KP_VIEW_MODEL_GET_CLASS (model)->set_log (model, log);
  g_signal_emit (model, kp_view_model_signals[LOG_SET], 0, log);
}

void
kp_view_model_unset_log (KPViewModel *model)
{
  g_signal_emit (model, kp_view_model_signals[LOG_UNSET], 0);
  KP_VIEW_MODEL_GET_CLASS (model)->unset_log (model);
}

void
kp_view_model_activate (KPViewModel *model)
{
  KP_VIEW_MODEL_GET_CLASS (model)->activate (model);
}

void
kp_view_model_deactivate (KPViewModel *model)
{
  KP_VIEW_MODEL_GET_CLASS (model)->deactivate (model);
}

gchar *
kp_view_model_get_icon_name (KPViewModel *model)
{
  g_return_val_if_fail (KP_VIEW_MODEL_GET_CLASS (model)->get_icon_name != NULL, NULL);
  
  return KP_VIEW_MODEL_GET_CLASS (model)->get_icon_name (model);
}

gchar *
kp_view_model_get_date_format (KPViewModel *model)
{
  KPViewModelType type;
  
  type = KP_VIEW_MODEL_GET_CLASS (model)->get_view_type (model);
  
  switch (type)
  {
    case KP_VIEW_MODEL_TYPE_WEEK:
      return g_strdup (_("Week %V/%G"));
      
    case KP_VIEW_MODEL_TYPE_MONTH:
      return g_strdup ("%B %Y");
      
    case KP_VIEW_MODEL_TYPE_YEAR:
      return g_strdup ("%Y");
    
    case KP_VIEW_MODEL_TYPE_ALL_TIME:
      return g_strdup (_("All time"));
    
    case KP_VIEW_MODEL_TYPE_DAY:
      return g_strdup ("%x");
    
    default:
      g_assert_not_reached ();
  }
  /* Prevent a compiler warning */
  return NULL;
}


gchar *
kp_view_model_type_to_string (KPViewModelType type, gchar **icon_name)
{
  struct {
    const gchar *name;
    const gchar *icon;
  } names[KP_VIEW_MODEL_TYPE_N] = {
    { N_("Day"),      "dayview.png"   },
    { N_("Week"),     "weekview.png"  },
    { N_("Month"),    "monthview.png" },
    { N_("Year"),     "yearview.png"  },
    { N_("All Time"), "alltime.png"   }
  };

  g_assert (sizeof (names) / sizeof (names[0]) == KP_VIEW_MODEL_TYPE_N);

  if (icon_name)
    *icon_name = g_strdup (names[type].icon);
  
  return g_strdup (names[type].name);
}




