#include "../../kipina-version.h" 
#include "../kipina-i18n.h"
#include "../kputil.h"

#include "kphtmlutil.h"


#define ODD_OR_EVEN     ((is_odd) ? "td_odd" : "td_even")
static gboolean is_odd = FALSE;
static guint col = 0;

void
change_parity (void)
{
  if (is_odd) {
    is_odd = FALSE;
  } else
    is_odd = TRUE;
}

#define TABLE_START  "<table class=\"table_stats\" width=\"100%\" cellspacing=\"0\"" \
                     "cellpadding=\"0\">\n"

void
kp_html_table_head_n (FILE *fp, const gchar **titles, guint n)
{
  gchar *format = "<th class=\"%s\">%s</th>\n";
  guint i;
  
  fputs (TABLE_START"<thead>\n<tr>\n", fp);
  
  fprintf (fp, format, "th_theadleft", titles[0]);
  for (i=1; i < n; i++)
    fprintf (fp, format, "th_thead", titles[i]);
  
  fputs ("</tr>\n</thead>\n<tbody>\n", fp);
  col = 0;
}


void
kp_html_table_head (FILE *fp, const gchar *title, ...)
{
  va_list args;
  gchar *arg;
  gchar *format = "<th class=\"%s\">%s</th>\n";

  fputs (TABLE_START"<thead>\n<tr>\n", fp);
  
  va_start (args, title);
  fprintf (fp, format, "th_theadleft", title);
  
  while ((arg = va_arg (args, gchar *))) 
    fprintf (fp, format, "th_thead", arg);
  
  va_end (args);
  
  fputs ("</tr>\n</thead>\n<tbody>\n", fp);

  /* Set same start for every table */
  is_odd = FALSE;
  col = 0;
}


void
kp_html_table_start (FILE *fp)
{
  fputs (TABLE_START"<tbody>\n", fp);
  col = 0;
}


void
kp_html_table_head_row (FILE *fp, const gchar *item, ...)
{
  va_list args;
  gchar *arg;
  gchar *format = "<td valign=\"top\" class=\"%s\">%s</td>\n";

  change_parity ();
  g_return_if_fail (item != NULL);
  
  fputs ("<tr>\n", fp);
  va_start (args, item);
  fprintf (fp, format, "subheadleft", item);
  while ((arg = va_arg (args, gchar *)) != NULL) 
    fprintf (fp, format, "subhead", arg);
  va_end (args);
  fputs ("</tr>\n", fp);
  col = 0;
}

void
kp_html_table_row (FILE *fp, const gchar *item, ...)
{
  va_list args;
  gchar *arg;
  gchar *format = "<td valign=\"top\" class=\"%s\">%s</td>\n";

  change_parity ();
  g_return_if_fail (item != NULL);
  
  fputs ("<tr>\n", fp);
  va_start (args, item);
 
  fprintf (fp, format, ODD_OR_EVEN, item);
  while ((arg = va_arg (args, gchar *)) != NULL) 
    fprintf (fp, format, ODD_OR_EVEN, arg);
  va_end (args);
  fputs ("</tr>\n", fp);
  col = 0;
}

void
kp_html_table_cell_full (FILE *fp, const gchar *klass, const gchar *style, 
                         gint colspan, gint rowspan, const gchar *format, ...)
{
  GString *buf;
  va_list args;

  buf = g_string_new ("<td ");

  if (klass)
    g_string_append_printf (buf, " class=\"%s\"", klass);
  if (style)
    g_string_append_printf (buf, " style=\"%s\"", style);
  if (colspan > 0)
    g_string_append_printf (buf, " colspan=\"%u\"", colspan);
  if (rowspan > 0)
    g_string_append_printf (buf, " rowspan=\"%u\"", rowspan);
    
  buf = g_string_append (buf, ">\n");
  if (format)
    buf = g_string_append (buf, format);
  buf = g_string_append (buf, "</td>\n");
 
  va_start (args, format);
  vfprintf (fp, buf->str, args);
  va_end (args);
  
  g_string_free (buf, TRUE);
  col++;
}

void
kp_html_table_cell (FILE *fp, const gchar *format, ...)
{
  va_list args;

  fprintf (fp, "<td valign=\"top\" class=\"%s\">", ODD_OR_EVEN);
  va_start (args, format);
  vfprintf (fp, format, args);
  va_end (args);
  fputs ("</td>\n", fp);
  col++;
}


void
kp_html_table_head_cell (FILE *fp, const gchar *format, ...)
{
  va_list args;

  fprintf (fp, "<td valign=\"top\" class=\"%s\">", 
      (col == 0) ? "subheadleft" : "subhead");

  va_start (args, format);
  vfprintf (fp, format, args);
  va_end (args);
  fputs ("</td>\n", fp);
  col++;
}

void
kp_html_table_cell_cspan (FILE *fp, guint cspan, const gchar *format, ...)
{
  va_list args;

  fprintf (fp, "<td valign=\"top\" colspan=\"%u\" class=\"%s\">",
               cspan, ODD_OR_EVEN);
  va_start (args, format);
  vfprintf (fp, format, args);
  va_end (args);
  fputs ("</td>\n", fp);
  col += cspan;
}

void
kp_html_table_row_start (FILE *fp)
{
  change_parity ();
  fputs ("<tr>\n", fp);
  col = 0;
}


void
kp_html_table_row_end (FILE *fp)
{
  fputs ("</tr>\n", fp);
}

void
kp_html_table_foot (FILE *fp)
{
  fputs ("</tbody>\n</table>\n", fp);
}


void
kp_html_h1 (FILE *fp, const gchar *format, ...)
{
  va_list args;

  fprintf (fp, "<h1>");
  
  va_start (args, format);
  vfprintf (fp, format, args);
  va_end (args);
  
  fprintf (fp, "</h1>\n");
}

static void
navi_link (FILE *fp, const gchar *uri, const gchar *name)
{
  fprintf (fp, "&nbsp;<b>\302\273</b>&nbsp;<a href=\"%s.html\">%s</a>\n", 
           uri, name);
}


/**
 * kp_html_navi_2:
 * @fp: A #FILE
 * @data: A #KPHtmlNaviData
 * @y: a Year
 * @m: A month between 1 and 12
 * @id: KPCalendarEntry Id
 *
 * Write navi bar to @fp.
 */
void
kp_html_navi (FILE *fp, KPHtmlNaviData *data, guint y, guint m, guint id)
{ 
  char buf_uri[64];
  char buf_name[64];
  guint i;
  
  fputs ("<div id=\"navi\">\n", fp);

  /* Index page link to all pages */
  navi_link (fp, "index", _("Main"));

  if (y) {
    g_snprintf (buf_uri, sizeof (buf_uri)-1, "year-%u", y);
    g_snprintf (buf_name, sizeof (buf_name)-1, _("Year %u"), y);
    navi_link (fp, buf_uri, buf_name);
  }
  
  if (m) {
    g_snprintf (buf_uri, sizeof (buf_uri)-1, "month-%u-%u", y, m);
    g_snprintf (buf_name, sizeof (buf_uri)-1, "%s %u", 
              _(kp_get_month_name (m-1)), y);
    navi_link (fp, buf_uri, buf_name);
  }
 
  if (id) {
    g_snprintf (buf_uri, sizeof (buf_uri)-1, "entry-%u", id);
    g_snprintf (buf_name, sizeof (buf_uri)-1, _("Entry (id: %u)"), id);
    navi_link (fp, buf_uri, buf_name);
  }
    
  /* If there are extra pages, put the links there */
  if (data->extra_page_names[0]) {
    fputs ("<br/>", fp);
    fputs ("<div style=\"text-align:right\">", fp);
  
    for (i=0; i < G_N_ELEMENTS (data->extra_page_names); i++) {
      if (data->extra_page_names[i] != NULL)
        fprintf (fp, "&nbsp;<a href=\"%s.html\">%s</a>&nbsp;", 
                 data->extra_page_uris[i],
                 data->extra_page_names[i]);
    }
    fputs ("</div>", fp);
  }
  
  fputs ("</div>", fp);
}

