#ifndef KP_PARAM_LIST_H_
#define KP_PARAM_LIST_H_

#include <glib.h>
#include <glib-object.h>
#include <libxml/tree.h>

#include "kpparam.h"

#define KP_TYPE_PARAM_LIST (kp_param_list_get_type())
#define KP_PARAM_LIST(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_PARAM_LIST, KPParamList))
#define KP_PARAM_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_PARAM_LIST, KPParamListClass))
#define KP_IS_PARAM_LIST(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_PARAM_LIST))
#define KP_IS_PARAM_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_PARAM_LIST))
#define KP_PARAM_LIST_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_PARAM_LIST, KPParamListClass))


typedef struct KPParamListCategory_ {
  gchar *name;
  GList *list;
} KPParamListCategory;

typedef struct KPParamList_
{
  GObject      parent_instance;

  GList       *list;    
}
KPParamList;

typedef struct KPParamListClass_ {
  GObjectClass parent_class;

  /* Signals */
  void       (*changed) (KPParamList *);
} KPParamListClass;


GType         kp_param_list_get_type              (void);

KPParamList  *kp_param_list_new                   (void);
void          kp_param_list_insert                (KPParamList *list,
                                                   const gchar *category,
                                                   KPParam *param);
void          kp_param_list_remove                (KPParamList *list,
                                                   const gchar *name);
KPParamList  *kp_param_list_copy                  (KPParamList *list);
void          kp_param_list_print                 (KPParamList *list);
KPParam      *kp_param_list_get_param             (KPParamList *list,
                                                   const gchar *name);
KPParamListCategory *
              kp_param_list_get_category          (KPParamList *list,
                                                   const gchar *name);
void          kp_param_list_set_param_string      (KPParamList *list,
                                                   const gchar *category,
                                                   const gchar *name,
                                                   const gchar *value);

void          kp_param_list_export_as_xml         (KPParamList *list,
                                                   xmlNodePtr parent);

/* Set */
void          kp_param_list_set_uint              (KPParamList *list, 
                                                   const gchar *category,
                                                   const gchar *param,
                                                   guint value);
void          kp_param_list_set_int               (KPParamList *list, 
                                                   const gchar *param,
                                                   gint value);
void          kp_param_list_set_double            (KPParamList *list,
                                                   const gchar *category,
                                                   const gchar *param,
                                                   gdouble value);
void          kp_param_list_set_boolean           (KPParamList *list, 
                                                   const gchar *param,
                                                   gboolean value);
void          kp_param_list_set_string            (KPParamList *list,
                                                   const gchar *category,
                                                   const gchar *param,
                                                   const gchar *value);
void          kp_param_list_set_pointer           (KPParamList *list,
                                                   const gchar *param,
                                                   gpointer value);
void          kp_param_list_set_object            (KPParamList *list, 
                                                   const gchar *param,
                                                   GObject *object);
void          kp_param_list_set_time              (KPParamList *list,
                                                   const gchar *category,
                                                   const gchar *param_name,
                                                   guint value);
/* Get */
gint          kp_param_list_get_int               (KPParamList *list,
                                                   const gchar *param);
guint         kp_param_list_get_uint              (KPParamList *list,
                                                   const gchar *param);
gdouble       kp_param_list_get_double            (KPParamList *list,
                                                   const gchar *param);
gboolean      kp_param_list_get_boolean           (KPParamList *list,
                                                   const gchar *param);
G_CONST_RETURN
gchar        *kp_param_list_get_string            (KPParamList *list,
                                                   const gchar *param);
gpointer      kp_param_list_get_pointer           (KPParamList *list,
                                                   const gchar *param);
GObject      *kp_param_list_get_object            (KPParamList *list,
                                                   const gchar *param);
guint         kp_param_list_get_time              (KPParamList *list,
                                                   const gchar *param);
gchar        *kp_param_list_get_as_string         (KPParamList *list,
                                                   const gchar *param);

#endif
