/*
 *  Klavier : Virtual keyboard for K Destop Environement
 *
 *  This program (klavier) is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 *  This program (klavier) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 * License along with this program (klavier); if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA. 
 *
 * Author : Sebastien HUSS <sebastien.huss@laposte.net>
 *
 */
#include "hwlwidget.h"
#include <qpainter.h>
#include <qtimer.h>

#include <iostream>
using namespace std;

#define WIDGET_WIDTH 80
#define WIDGET_HEIGHT 100


HwlWidget::HwlWidget(QWidget *parent, const char *name)
	: QWidget(parent, name),pressed(false)
{
	this->bit	= NULL;
	this->paint	= new QPainter(this);
	this->setFixedSize(WIDGET_WIDTH, WIDGET_HEIGHT);
	this->timer	= new QTimer(this, "Stop record timer");
	this->stroke	= new Stroke(this, "Stroke");
	connect(this->timer, SIGNAL(timeout()), this, SLOT(timeUp()));
}

void HwlWidget::paintEvent( QPaintEvent * )
{
	drawIt( this->paint );
}

void HwlWidget::drawIt(QPainter *p)
{
	QBrush		b(Qt::yellow);
	p->setPen(Qt::NoPen);
	p->setBrush(b);
//	p->drawRect(0,0,WIDGET_WIDTH,WIDGET_HEIGHT);
	p->setPen(Qt::black);

}

/*
 * Drawing feature
 */
void HwlWidget::mousePressEvent( QMouseEvent *e )
{
	if (this->timer->isActive())
		this->timer->stop();
	this->pressed	= true;
	this->mouseMoveEvent(e);
}
void HwlWidget::mouseReleaseEvent( QMouseEvent *e )
{
	this->pressed	= false;
	if (this->timer->isActive())
		this->timer->stop();
	this->timer->start(500, TRUE);
	this->mouseMoveEvent(e);
	this->stroke->nextSegment();
}
void HwlWidget::mouseMoveEvent( QMouseEvent *e )
{
	int	x = e->x()<0?0:(e->x()>WIDGET_WIDTH?WIDGET_WIDTH:e->x());
	int	y = e->y()<0?0:(e->y()>WIDGET_HEIGHT?WIDGET_HEIGHT:e->y());
	this->paint->drawPoint(x, y);
	this->stroke->addPoint(new QPoint(x, y));
}
void HwlWidget::timeUp()
{
	StrokeBitmap	* bits	= this->stroke->toBitmap();
	if (this->bit == NULL)
		this->bit = bits;
	else
	{
		cout << this->bit->matchingScore(bits) << endl;
	}
	this->timer->stop();
	this->paint->eraseRect(0, 0, WIDGET_WIDTH, WIDGET_HEIGHT);
	
	this->drawIt(this->paint);
	
	// renew data
	delete this->stroke;
	this->stroke = new Stroke(this, "Stroke");
}

HwlWidget::~HwlWidget()
{
	delete	this->paint;
}


#include "hwlwidget.moc"
