/*
 *  Klavier : Virtual keyboard for K Destop Environement
 *
 *  This program (klavier) is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 *  This program (klavier) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 * License along with this program (klavier); if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA. 
 *
 * Author : Sebastien HUSS <sebastien.huss@laposte.net>
 *
 */
#include "keyboardwidget.h"

KeyCode	KeyboardWidget::keycodes[NUM_KEY_ROWS][NUM_KEY_COLS] = {
{ 9,  67, 68, 69, 70, 71, 72, 73, 74, 75,  76,  95,  96,   0, 111,  78, 110,  0,   0,  0,   0},
{49,  10, 11, 12, 13, 14, 15, 16, 17, 18,  19,  20,  21,  22, 106,  97,  99, 77, 112, 63,  82},
{23,  24, 25, 26, 27, 28, 29, 30, 31, 32,  33,  34,  35,  36,  91, 103, 105, 79,  80, 81,  86},
{66,  38, 39, 40, 41, 42, 43, 44, 45, 46,  47,  48,  51,   0,   0,   0,   0, 83,  84, 85,   0},
{50,  94, 52, 53, 54, 55, 56, 57, 58, 59,  60,  61,  62,   0,   0,  98,   0, 87,  88, 89, 108},
{37, 115, 64, 65,  0,  0,  0,  0,  0,  0, 113, 116, 117, 109, 100, 104, 102, 90,   0, 91,   0}
};

void	KeyboardWidget::majDown()
{
	if(this->majModifier != NULL)
		this->majModifier->set();
}

bool	KeyboardWidget::mustUseMajLimit(KeyCode kc)
{
	return (9<kc&&kc<22)||(23<kc&&kc<36)||(37<kc&&kc<62)||(kc==94);
}
void	KeyboardWidget::setUseMajLimit(bool useMaj)
{
	this->cfgUseMajLimit = useMaj;
}

bool	KeyboardWidget::isModifier(KeyCode kc)
{
	switch(kc)
	{
		case 37:
		case 115:
		case 64:
		case 116:
		case 109:
		case 50:
		case 62:
		case 113:
			return true;
		default:
			return false;
	}
}
void	KeyboardWidget::releaseModifiers()
{
	for (int i=0; i<NUM_MODIFIER; i++)
	{
		if (this->modifiers[i] != NULL)
			this->modifiers[i]->release();
	}
}
void	KeyboardWidget::sendModifiersDown()
{
	for (int i=0; i<NUM_MODIFIER; i++)
	{
		if (this->modifiers[i] != NULL)
			this->modifiers[i]->sendDown();
	}
}

KeyboardWidget::KeyboardWidget(sendKey * wire, QWidget * parent, const char * name)
	: QWidget(parent, name)
{
	int	mod	= 0;
	this->wire	= wire;
	this->cfgUseMajLimit = false;

	setMinimumSize( QSize( 600, 140 ) );
	for(int i=0;i<NUM_MODIFIER;i++)
		this->modifiers[i]	= NULL;

	for(int i=0;i<NUM_KEY_ROWS;i++)
	{
		for(int j=0;j<NUM_KEY_COLS;j++)
		{
			this->setFocusPolicy(NoFocus);
			if (this->keycodes[i][j]>0 && this->isModifier(this->keycodes[i][j]))
			{
				this->modifiers[mod] = new KeyboardModifier(this->wire, this->keycodes[i][j], this);
				this->buttons[i][j] = this->modifiers[mod];
				this->buttons[i][j]->setLogicalCoord(j, i);
				this->buttons[i][j]->resizeToLogical(this->size());
				if (this->keycodes[i][j] == 50)
					this->majModifier = this->modifiers[mod];
				mod++;
			}
			else if (this->keycodes[i][j]>0) // && !isModifier
			{
				this->buttons[i][j] = new KeyboardKeys(this->wire, this->keycodes[i][j], this);
				this->buttons[i][j]->setLogicalCoord(j, i);
				this->buttons[i][j]->resizeToLogical(this->size());
			}
			else
				this->buttons[i][j] = NULL;
		}
	}
}

void	KeyboardWidget::resizeEvent(QResizeEvent* re)
{
	for(int i=0;i<NUM_KEY_ROWS;i++)
	{
		for(int j=0;j<NUM_KEY_COLS;j++)
		{
			if (this->keycodes[i][j]>0)
			{
				this->buttons[i][j]->resizeToLogical(re->size());
			}
		}
	}
}

KeyboardWidget::~KeyboardWidget()
{
}

#include "keyboardwidget.moc"
