/*
 *  Klavier : Virtual keyboard for K Destop Environement
 *
 *  This program (klavier) is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 *  This program (klavier) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 * License along with this program (klavier); if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA. 
 *
 * Author : Sebastien HUSS <sebastien.huss@laposte.net>
 *
 */
#ifndef KLAVIERWIDGET_H
#define KLAVIERWIDGET_H

#include <qwidget.h>
#include <qlayout.h>
class sendKey;
class KeyboardWidget;
class QPushButton;
class QWidgetStack;
class HwlHandler;
/**
	@author Sebastien HUSS <sebastien.huss@laposte.net>
 */
class KlavierWidget : public QWidget
{
	Q_OBJECT
	public:
		KlavierWidget(sendKey * wire, QWidget *parent = 0, const char *name = 0);

		~KlavierWidget();
		
		KeyboardWidget*	getKeyboard() {return this->keyboard;}
	public slots:
		void	kbButtonClicked();
		void	hwlButtonClicked();

	private:
		QBoxLayout	*topLayout;
		QBoxLayout	*leftLayout;
//		QBoxLayout	*rightLayout;
		KeyboardWidget	*keyboard;
		QWidgetStack	*stack;
		QPushButton	*kbButton;
		QPushButton	*hwlButton;
		HwlHandler	*hwletter;

};

#endif
