#ifndef __RAMW_CLASS
#define __RAMW_CLASS

class QWidget;
class QPaintEvent;
class QCheckBox;
class QButtonGroup;
class QScrollBar;
class XDevice;
class XWire;
class RAMWidget;

class RAMScrollWidget : public QWidget
{	Q_OBJECT
public:
	RAMScrollWidget(QWidget *, const char *, XDevice *);
	~RAMScrollWidget();
	void setGeometry(int, int, int, int);
	void paintEvent(QPaintEvent *);
	void setBitButtons();
	static int neededWidth();
	char *getNewRAMContent();
	void setRAM(char);

private slots:
	void vScroll(int);

private:
	void adjustScroll();

	RAMWidget *ramw;
	QScrollBar *vscroll;
	int curr_y_size;
};


class RAMWidget : public QWidget
{	Q_OBJECT
public:
	RAMWidget(QWidget *, const char *, XDevice *);
	~RAMWidget();
	void setGeometry(int, int, int, int);
	void paintEvent(QPaintEvent *);
	void setBitButtons(int);
	void removeBitButtons();
	static int neededWidth();
	char *getNewRAMContent();
	void setRAM(char);

private slots:
	void bitButton(int);

private:
	int xpos, ypos;
	int byte_cnt;
	QButtonGroup *bitgroup;
	QCheckBox *bitswitch[256][8];
	QPixmap *pix_inputval;
	char *ram;
};

#endif
